"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistNoteRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/constants");
var _utils = require("../../../detection_engine/routes/utils");
var _common = require("../../utils/common");
var _timeline = require("../../../../../common/api/timeline");
var _notes = require("../../saved_object/notes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const persistNoteRoute = router => {
  router.versioned.patch({
    path: _constants.NOTE_URL,
    security: {
      authz: {
        requiredPrivileges: ['notes_write']
      }
    },
    access: 'public'
  }).addVersion({
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_timeline.PersistNoteRouteRequestBody)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _request$body$noteId, _request$body;
      const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
      const {
        note
      } = request.body;
      const noteId = (_request$body$noteId = (_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.noteId) !== null && _request$body$noteId !== void 0 ? _request$body$noteId : null;
      const res = await (0, _notes.persistNote)({
        request: frameworkRequest,
        noteId,
        note,
        overrideOwner: true
      });
      const body = {
        data: {
          persistNote: res
        }
      };
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.persistNoteRoute = persistNoteRoute;