"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readTagsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../../../common/constants");
var _utils = require("../../../../routes/utils");
var _read_tags = require("./read_tags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readTagsRoute = router => {
  router.versioned.get({
    access: 'public',
    path: _constants.DETECTION_ENGINE_TAGS_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: false
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const ctx = await context.resolve(['alerting']);
    const rulesClient = await ctx.alerting.getRulesClient();
    try {
      const tags = await (0, _read_tags.readTags)({
        rulesClient
      });
      return response.ok({
        body: tags
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.readTagsRoute = readTagsRoute;