"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConcurrencyErrors = void 0;
var _utils = require("../../../rule_management/utils/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConcurrencyErrors = (revision, version, rule) => {
  if (rule.version !== version) {
    return (0, _utils.createBulkActionError)({
      id: rule.id,
      message: `Version mismatch for rule with id: ${rule.id}. Expected ${version}, got ${rule.version}`,
      statusCode: 409
    });
  }
  if (rule.revision !== revision) {
    return (0, _utils.createBulkActionError)({
      id: rule.id,
      message: `Revision mismatch for rule with id: ${rule.id}. Expected ${revision}, got ${rule.revision}`,
      statusCode: 409
    });
  }
};
exports.getConcurrencyErrors = getConcurrencyErrors;