"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AppClient", {
  enumerable: true,
  get: function () {
    return _types.AppClient;
  }
});
exports.plugin = exports.config = void 0;
var _config = require("./config");
var _constants = require("../common/constants");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const plugin = async context => {
  const {
    Plugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new Plugin(context);
};
exports.plugin = plugin;
const config = exports.config = {
  exposeToBrowser: {
    enableExperimental: true,
    prebuiltRulesPackageVersion: true,
    offeringSettings: true
  },
  schema: _config.configSchema,
  deprecations: ({
    renameFromRoot,
    unused
  }) => [renameFromRoot('xpack.siem.enabled', 'xpack.securitySolution.enabled', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxRuleImportExportSize', 'xpack.securitySolution.maxRuleImportExportSize', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxRuleImportPayloadBytes', 'xpack.securitySolution.maxRuleImportPayloadBytes', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxTimelineImportExportSize', 'xpack.securitySolution.maxTimelineImportExportSize', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxTimelineImportPayloadBytes', 'xpack.securitySolution.maxTimelineImportPayloadBytes', {
    level: 'critical'
  }), renameFromRoot(`xpack.siem.${_constants.SIGNALS_INDEX_KEY}`, `xpack.securitySolution.${_constants.SIGNALS_INDEX_KEY}`, {
    level: 'critical'
  }), unused('ruleExecutionLog.underlyingClient', {
    level: 'warning'
  }), unused('prebuiltRulesFromFileSystem', {
    level: 'warning'
  }), unused('prebuiltRulesFromSavedObjects', {
    level: 'warning'
  })]
};