"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_FIELD_TYPE = exports.AlertFieldBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../../../common/components/draggables");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIELD_TYPE = exports.DEFAULT_FIELD_TYPE = 'keyword';
const AlertFieldBadgeComponent = ({
  contextId,
  eventId,
  field,
  fieldType = DEFAULT_FIELD_TYPE,
  isAggregatable = true,
  showSeparator,
  scopeId,
  value
}) => /*#__PURE__*/_react.default.createElement(_helpers.AlertFieldFlexGroup, {
  alignItems: "center",
  "data-test-subj": "alertFieldBadge",
  $scopeId: scopeId,
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: `${contextId}-alert-field`,
  eventId: eventId,
  field: field,
  fieldType: fieldType,
  isAggregatable: isAggregatable,
  scopeId: scopeId,
  value: value
})), showSeparator && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "separator"
}, ', ')));
AlertFieldBadgeComponent.displayName = 'AlertFieldBadgeComponent';
const AlertFieldBadge = exports.AlertFieldBadge = /*#__PURE__*/_react.default.memo(AlertFieldBadgeComponent);