"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _link_card = require("./link_card.styles");
var _constants = require("../../constants");
var _onboarding_context = require("../../../onboarding_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkCard = exports.LinkCard = /*#__PURE__*/_react.default.memo(({
  id,
  icon,
  title,
  description,
  onClick,
  href,
  target,
  linkText
}) => {
  const cardStyles = (0, _link_card.useCardStyles)();
  const cardClassName = (0, _classnames.default)(cardStyles, 'headerCard');
  const {
    telemetry: {
      reportLinkClick
    }
  } = (0, _onboarding_context.useOnboardingContext)();
  const onClickWithReport = (0, _react.useCallback)(() => {
    reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(`${_constants.TELEMETRY_HEADER_CARD}_${id}`);
    onClick === null || onClick === void 0 ? void 0 : onClick();
  }, [id, onClick, reportLinkClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    className: cardClassName,
    onClick: onClickWithReport,
    href: href,
    target: target,
    "data-test-subj": "data-ingestion-header-card",
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      "data-test-subj": "data-ingestion-header-card-icon",
      src: icon,
      alt: title,
      size: 64
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      className: "headerCardTitle"
    }, /*#__PURE__*/_react.default.createElement("h3", null, title)),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, description)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "headerCardLink"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "headerCardLink",
    href: href,
    onClick: onClick,
    target: target
  }, linkText)));
});
LinkCard.displayName = 'LinkCard';