"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardContentPanelStyles = exports.NESTED_PANEL_CLASS_NAME = void 0;
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _onboarding_card_panel = require("../../onboarding_card_panel.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NESTED_PANEL_CLASS_NAME = exports.NESTED_PANEL_CLASS_NAME = 'onboardingCardContentPanelNested';
const useCardContentPanelStyles = () => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const darkPanelStyles = (0, _onboarding_card_panel.useDarkPanelStyles)(colorMode === _eui.COLOR_MODES_STANDARD.dark);
  return (0, _css.css)`
    padding-top: 0;
    ${darkPanelStyles}

    .${NESTED_PANEL_CLASS_NAME} {
      padding-top: ${euiTheme.size.s};
      ${darkPanelStyles}
    }
  `;
};
exports.useCardContentPanelStyles = useCardContentPanelStyles;