"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUninitialisedResourceState = exports.createLoadingResourceState = exports.createLoadedResourceState = exports.createFailedResourceState = exports.asStaleResourceState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUninitialisedResourceState = () => {
  return {
    type: 'UninitialisedResourceState'
  };
};
exports.createUninitialisedResourceState = createUninitialisedResourceState;
const createLoadingResourceState = previousState => {
  return {
    type: 'LoadingResourceState',
    previousState
  };
};
exports.createLoadingResourceState = createLoadingResourceState;
const createLoadedResourceState = data => {
  return {
    type: 'LoadedResourceState',
    data
  };
};
exports.createLoadedResourceState = createLoadedResourceState;
const createFailedResourceState = (error, lastLoadedState) => {
  return {
    type: 'FailedResourceState',
    error,
    lastLoadedState
  };
};
exports.createFailedResourceState = createFailedResourceState;
/**
 * Takes an existing AsyncResourceState and transforms it into a StaleResourceState (not loading)
 * Note: If a loading state is passed, the resource is returned as UninitialisedResourceState
 */
const asStaleResourceState = resource => {
  switch (resource.type) {
    case 'LoadedResourceState':
      return resource;
    case 'FailedResourceState':
      return resource;
    case 'UninitialisedResourceState':
    case 'LoadingResourceState':
      return createUninitialisedResourceState();
  }
};
exports.asStaleResourceState = asStaleResourceState;