"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _use_license = require("../../../common/hooks/use_license");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _view = require("./view");
var _constants = require("../../common/constants");
var _ = require("../../../app/404");
var _routing = require("../../common/routing");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyContainer = exports.PolicyContainer = /*#__PURE__*/(0, _react.memo)(() => {
  const isProtectionUpdatesFeatureEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('protectionUpdatesEnabled');
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const isProtectionUpdatesEnabled = isEnterprise && isProtectionUpdatesFeatureEnabled;
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: [_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH, ...(isProtectionUpdatesEnabled ? [_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH] : [])],
    exact: true,
    component: _view.PolicyDetails
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD,
    exact: true,
    render: props => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: (0, _routing.getPolicyDetailPath)(props.match.params.policyId)
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.MANAGEMENT_ROUTING_POLICIES_PATH,
    exact: true,
    component: _view.PolicyList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    component: _.NotFoundPage
  }));
});
PolicyContainer.displayName = 'PolicyContainer';