"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NO_HISTORY_EMPTY_MESSAGE = exports.CommandInputHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_with_input_text_entered = require("../../../hooks/state_selectors/use_with_input_text_entered");
var _user_command_input = require("../../user_command_input");
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _use_with_input_history = require("../../../hooks/state_selectors/use_with_input_history");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
var _command_input_clear_history = require("./command_input_clear_history");
var _console_state = require("../../console_state/console_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_HISTORY_EMPTY_MESSAGE = exports.NO_HISTORY_EMPTY_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.commandInputHistory.noHistoryEmptyMessage', {
  defaultMessage: 'No commands have been entered'
});
const FILTER_HISTORY_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.commandInputHistory.filterPlaceholder', {
  defaultMessage: 'Filter previously entered actions'
});
const NO_FILTERED_MATCHES = _i18n.i18n.translate('xpack.securitySolution.commandInputHistory.noFilteredMatchesFoundMessage', {
  defaultMessage: 'No entries found matching the filter entered'
});
const CommandInputHistory = exports.CommandInputHistory = /*#__PURE__*/(0, _react.memo)(() => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const inputHistory = (0, _use_with_input_history.useWithInputHistory)();
  const {
    state: consoleState
  } = (0, _console_state.useConsoleStore)();
  const [priorInputState] = (0, _react.useState)((0, _use_with_input_text_entered.useWithInputTextEntered)());
  const optionWasSelected = (0, _react.useRef)(false);
  const selectableHistoryOptions = (0, _react.useMemo)(() => {
    return inputHistory.map((inputItem, index) => {
      return {
        label: inputItem.display,
        key: inputItem.id,
        data: inputItem
      };
    });
  }, [inputHistory]);
  const selectableListProps = (0, _react.useMemo)(() => {
    return {
      showIcons: false,
      bordered: true
    };
  }, []);
  const selectableSearchProps = (0, _react.useMemo)(() => {
    return {
      placeholder: FILTER_HISTORY_PLACEHOLDER,
      compressed: true,
      fullWidth: true
    };
  }, []);
  const renderSelectionContent = (0, _react.useCallback)((list, search) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, list, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), inputHistory.length > 0 ? search : /*#__PURE__*/_react.default.createElement("div", {
      tabIndex: -1
    }));
  }, [inputHistory.length]);
  const handleSelectableOnChange = (0, _react.useCallback)(items => {
    optionWasSelected.current = true;
    const selected = items.find(item => item.checked === 'on');
    dispatch({
      type: 'updateInputPopoverState',
      payload: {
        show: undefined
      }
    });
    dispatch({
      type: 'updateInputPlaceholderState',
      payload: {
        placeholder: ''
      }
    });
    if (selected) {
      const historyItem = selected.data;
      const originalArgState = historyItem.argState;

      // Clean file selector values from history argState
      // File selectors (selectorShowTextValue !== true) should not populate from history
      const cleanedArgState = {};
      if (originalArgState) {
        // Get command definitions to check selectorShowTextValue
        const commandName = historyItem.input.split(' ')[0];
        const commandDef = consoleState.commands.find(def => def.name === commandName);
        for (const [argName, argValues] of Object.entries(originalArgState)) {
          var _commandDef$args;
          const argDef = commandDef === null || commandDef === void 0 ? void 0 : (_commandDef$args = commandDef.args) === null || _commandDef$args === void 0 ? void 0 : _commandDef$args[argName];
          if (argDef !== null && argDef !== void 0 && argDef.SelectorComponent && argDef.selectorShowTextValue !== true) {
            // File selectors: Clear values (set to empty)
            cleanedArgState[argName] = [];
          } else {
            // Script selectors: Keep original values
            cleanedArgState[argName] = argValues;
          }
        }
      }
      dispatch({
        type: 'updateInputTextEnteredState',
        payload: {
          leftOfCursorText: historyItem.input,
          rightOfCursorText: '',
          argState: cleanedArgState
        }
      });
    }
    dispatch({
      type: 'addFocusToKeyCapture'
    });
  }, [consoleState.commands, dispatch]);
  const handleOnActiveOptionChange = (0, _react.useCallback)(option => {
    if (option) {
      dispatch({
        type: 'updateInputPlaceholderState',
        payload: {
          placeholder: option.data.input
        }
      });
    }
  }, [dispatch]);
  const handleRenderOption = (0, _react.useCallback)(option => {
    return /*#__PURE__*/_react.default.createElement(_user_command_input.UserCommandInput, {
      input: option.label
    });
  }, []);

  // When first loaded, clear out the current text entered, and when this component
  // unloads, if no option from the history was selected, then set the prior text
  // entered back
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'updateInputTextEnteredState',
      payload: {
        leftOfCursorText: '',
        rightOfCursorText: ''
      }
    });
    return () => {
      if (!optionWasSelected.current) {
        dispatch({
          type: 'updateInputTextEnteredState',
          payload: {
            leftOfCursorText: priorInputState.leftOfCursorText,
            rightOfCursorText: priorInputState.rightOfCursorText
          }
        });
        dispatch({
          type: 'updateInputPlaceholderState',
          payload: {
            placeholder: ''
          }
        });
      }
    };
  }, [dispatch, optionWasSelected, priorInputState]);
  return /*#__PURE__*/_react.default.createElement("div", null, inputHistory.length > 0 && /*#__PURE__*/_react.default.createElement(_command_input_clear_history.CommandInputClearHistory, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: selectableHistoryOptions,
    onChange: handleSelectableOnChange,
    onActiveOptionChange: handleOnActiveOptionChange,
    renderOption: handleRenderOption,
    listProps: selectableListProps,
    singleSelection: true,
    searchable: true,
    searchProps: selectableSearchProps,
    emptyMessage: NO_HISTORY_EMPTY_MESSAGE,
    noMatchesMessage: NO_FILTERED_MATCHES,
    "data-test-subj": getTestId('inputHistorySelector'),
    "data-console-input-history": true
  }, renderSelectionContent));
});
CommandInputHistory.displayName = 'CommandInputHistory';