"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_TYPE_DESCRIPTION = exports.THRESHOLD_RESULTS_ALL = exports.THRESHOLD_RESULTS_AGGREGATED_BY = exports.THRESHOLD_CARDINALITY = exports.THREAT_QUERY_LABEL = exports.THREAT_MATCH_TYPE_DESCRIPTION = exports.SAVED_QUERY_NAME_LABEL = exports.SAVED_QUERY_LABEL = exports.SAVED_QUERY_FILTERS_LABEL = exports.QUERY_TYPE_DESCRIPTION = exports.QUERY_LABEL = exports.NEW_TERMS_TYPE_DESCRIPTION = exports.ML_TYPE_DESCRIPTION = exports.FILTERS_LABEL = exports.ESQL_TYPE_DESCRIPTION = exports.ESQL_QUERY_LABEL = exports.EQL_TYPE_DESCRIPTION = exports.EQL_TIMESTAMP_FIELD_LABEL = exports.EQL_TIEBREAKER_FIELD_LABEL = exports.EQL_QUERY_LABEL = exports.EQL_EVENT_CATEGORY_FIELD_LABEL = exports.BUILDING_BLOCK_LABEL = exports.BUILDING_BLOCK_DESCRIPTION = exports.ALERT_SUPPRESSION_SUPPRESS_ON_MISSING_FIELDS = exports.ALERT_SUPPRESSION_PER_RULE_EXECUTION = exports.ALERT_SUPPRESSION_LABEL = exports.ALERT_SUPPRESSION_DO_NOT_SUPPRESS_ON_MISSING_FIELDS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTERS_LABEL = exports.FILTERS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.filtersLabel', {
  defaultMessage: 'Filters'
});
const QUERY_LABEL = exports.QUERY_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.queryLabel', {
  defaultMessage: 'Custom query'
});
const EQL_QUERY_LABEL = exports.EQL_QUERY_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.eqlQueryLabel', {
  defaultMessage: 'EQL query'
});
const ESQL_QUERY_LABEL = exports.ESQL_QUERY_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.esqlQueryLabel', {
  defaultMessage: 'ES|QL query'
});
const THREAT_QUERY_LABEL = exports.THREAT_QUERY_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.threatQueryLabel', {
  defaultMessage: 'Indicator index query'
});
const SAVED_QUERY_NAME_LABEL = exports.SAVED_QUERY_NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.savedIdLabel', {
  defaultMessage: 'Saved query name'
});
const SAVED_QUERY_FILTERS_LABEL = exports.SAVED_QUERY_FILTERS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.savedQueryFiltersLabel', {
  defaultMessage: 'Saved query filters'
});
const SAVED_QUERY_LABEL = exports.SAVED_QUERY_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.savedQueryLabel', {
  defaultMessage: 'Saved query'
});
const ML_TYPE_DESCRIPTION = exports.ML_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.mlRuleTypeDescription', {
  defaultMessage: 'Machine Learning'
});
const EQL_TYPE_DESCRIPTION = exports.EQL_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.eqlRuleTypeDescription', {
  defaultMessage: 'Event Correlation'
});
const QUERY_TYPE_DESCRIPTION = exports.QUERY_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.queryRuleTypeDescription', {
  defaultMessage: 'Query'
});
const THRESHOLD_TYPE_DESCRIPTION = exports.THRESHOLD_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.thresholdRuleTypeDescription', {
  defaultMessage: 'Threshold'
});
const THREAT_MATCH_TYPE_DESCRIPTION = exports.THREAT_MATCH_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.threatMatchRuleTypeDescription', {
  defaultMessage: 'Indicator Match'
});
const NEW_TERMS_TYPE_DESCRIPTION = exports.NEW_TERMS_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.newTermsRuleTypeDescription', {
  defaultMessage: 'New Terms'
});
const ESQL_TYPE_DESCRIPTION = exports.ESQL_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.esqlRuleTypeDescription', {
  defaultMessage: 'ES|QL'
});
const THRESHOLD_RESULTS_ALL = exports.THRESHOLD_RESULTS_ALL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.thresholdResultsAllDescription', {
  defaultMessage: 'All results'
});
const THRESHOLD_RESULTS_AGGREGATED_BY = exports.THRESHOLD_RESULTS_AGGREGATED_BY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.thresholdResultsAggregatedByDescription', {
  defaultMessage: 'Results aggregated by'
});
const THRESHOLD_CARDINALITY = (thresholdFieldsGroupedBy, cardinalityField, cardinalityValue) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.thresholdResultsCardinalityDescription', {
  defaultMessage: '{thresholdFieldsGroupedBy} when unique values count of {cardinalityField} >= {cardinalityValue}',
  values: {
    thresholdFieldsGroupedBy,
    cardinalityField,
    cardinalityValue
  }
});
exports.THRESHOLD_CARDINALITY = THRESHOLD_CARDINALITY;
const EQL_EVENT_CATEGORY_FIELD_LABEL = exports.EQL_EVENT_CATEGORY_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.eqlEventCategoryFieldLabel', {
  defaultMessage: 'Event category field'
});
const EQL_TIEBREAKER_FIELD_LABEL = exports.EQL_TIEBREAKER_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.eqlTiebreakerFieldLabel', {
  defaultMessage: 'Tiebreaker field'
});
const EQL_TIMESTAMP_FIELD_LABEL = exports.EQL_TIMESTAMP_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.eqlTimestampFieldLabel', {
  defaultMessage: 'Timestamp field'
});
const ALERT_SUPPRESSION_PER_RULE_EXECUTION = exports.ALERT_SUPPRESSION_PER_RULE_EXECUTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.alertSuppressionPerRuleExecution', {
  defaultMessage: 'One rule execution'
});
const ALERT_SUPPRESSION_SUPPRESS_ON_MISSING_FIELDS = exports.ALERT_SUPPRESSION_SUPPRESS_ON_MISSING_FIELDS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.alertSuppressionSuppressOnMissingFieldsDescription', {
  defaultMessage: 'Suppress and group alerts for events with missing fields'
});
const ALERT_SUPPRESSION_DO_NOT_SUPPRESS_ON_MISSING_FIELDS = exports.ALERT_SUPPRESSION_DO_NOT_SUPPRESS_ON_MISSING_FIELDS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.alertSuppressionDoNotSuppressOnMissingFieldsDescription', {
  defaultMessage: 'Do not suppress alerts for events with missing fields'
});
const BUILDING_BLOCK_LABEL = exports.BUILDING_BLOCK_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.buildingBlockLabel', {
  defaultMessage: 'Building block'
});
const BUILDING_BLOCK_DESCRIPTION = exports.BUILDING_BLOCK_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.buildingBlockDescription', {
  defaultMessage: 'All generated alerts will be marked as building block alerts'
});
const ALERT_SUPPRESSION_LABEL = exports.ALERT_SUPPRESSION_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.alertSuppressionFieldsLabel', {
  defaultMessage: 'Suppress alerts by'
});