"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../lib/kibana");
var _external_link = require("./external_link");
var _links_translations = require("./links_translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocLink = ({
  guidePath = 'security',
  docPath,
  linkText
}) => {
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    ELASTIC_WEBSITE_URL,
    DOC_LINK_VERSION
  } = services.docLinks;
  const url = `${ELASTIC_WEBSITE_URL}guide/en/${guidePath}/${DOC_LINK_VERSION}/${docPath}`;
  const ariaLabel = `${linkText} - ${_links_translations.COMMON_ARIA_LABEL_ENDING}`;
  return /*#__PURE__*/_react.default.createElement(_external_link.ExternalLink, {
    url: url,
    ariaLabel: ariaLabel
  }, linkText);
};

/**
 * A simple text link to documentation.
 */
const DocLinkWrapper = exports.DocLink = /*#__PURE__*/(0, _react.memo)(DocLink);