"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInspect = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../store/inputs/constants");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
var _actions = require("../../store/actions");
var _timeline = require("../../../../common/types/timeline");
var _selectors = require("../../../timelines/store/selectors");
var _defaults = require("../../../timelines/store/defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInspect = ({
  inputId = _constants.InputsModelId.global,
  inspectIndex = 0,
  isDisabled,
  multiple = false,
  // If multiple = true we ignore the inspectIndex and pass all requests and responses to the inspect modal
  onClick,
  onCloseInspect,
  queryId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getGlobalQuery = (0, _react.useMemo)(() => _store.inputsSelectors.globalQueryByIdSelector(), []);
  const getTimelineQuery = (0, _react.useMemo)(() => _store.inputsSelectors.timelineQueryByIdSelectorFactory(), []);
  const {
    activeTab
  } = (0, _reactRedux.useSelector)(state => {
    var _selectTimelineById;
    return (_selectTimelineById = (0, _selectors.selectTimelineById)(state, _timeline.TimelineId.active)) !== null && _selectTimelineById !== void 0 ? _selectTimelineById : _defaults.timelineDefaults;
  });
  const {
    loading,
    inspect,
    selectedInspectIndex,
    isInspected,
    searchSessionId
  } = (0, _use_selector.useDeepEqualSelector)(state => inputId === _constants.InputsModelId.global ? getGlobalQuery(state, queryId) : getTimelineQuery(state, `${_timeline.TimelineId.active}-${activeTab}`));
  const handleClick = (0, _react.useCallback)(() => {
    if (onClick) {
      onClick();
    }
    dispatch(_actions.inputsActions.setInspectionParameter({
      id: queryId,
      inputId,
      isInspected: true,
      selectedInspectIndex: inspectIndex,
      searchSessionId
    }));
  }, [onClick, dispatch, queryId, inputId, inspectIndex, searchSessionId]);
  const handleCloseModal = (0, _react.useCallback)(() => {
    if (onCloseInspect != null) {
      onCloseInspect();
    }
    dispatch(_actions.inputsActions.setInspectionParameter({
      id: queryId,
      inputId,
      isInspected: false,
      selectedInspectIndex: inspectIndex,
      searchSessionId
    }));
  }, [onCloseInspect, dispatch, queryId, inputId, inspectIndex, searchSessionId]);
  const request = (0, _react.useMemo)(() => {
    if (inspect != null && inspect.dsl.length > 0) {
      if (multiple) {
        return inspect.dsl[0];
      } else {
        return inspect.dsl[inspectIndex];
      }
    }
    return null;
  }, [inspectIndex, multiple, inspect]);
  const additionalRequests = (0, _react.useMemo)(() => {
    if (multiple) {
      return inspect === null || inspect === void 0 ? void 0 : inspect.dsl.slice(1);
    } else {
      return null;
    }
  }, [multiple, inspect]);
  const response = (0, _react.useMemo)(() => {
    if (inspect != null && inspect.response.length > 0) {
      if (multiple) {
        return inspect.response[0];
      } else {
        return inspect.response[inspectIndex];
      }
    }
    return null;
  }, [inspectIndex, multiple, inspect]);
  const additionalResponses = (0, _react.useMemo)(() => {
    if (multiple) {
      return inspect === null || inspect === void 0 ? void 0 : inspect.response.slice(1);
    } else {
      return null;
    }
  }, [multiple, inspect]);
  const isShowingModal = (0, _react.useMemo)(() => !loading && selectedInspectIndex === inspectIndex && isInspected, [inspectIndex, isInspected, loading, selectedInspectIndex]);
  const isButtonDisabled = (0, _react.useMemo)(() => loading || isDisabled || request == null || response == null || queryId == null, [isDisabled, loading, queryId, request, response]);
  return {
    additionalRequests,
    additionalResponses,
    handleClick,
    handleCloseModal,
    isButtonDisabled,
    isShowingModal,
    loading,
    request,
    response
  };
};
exports.useInspect = useInspect;