"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUS_ALERTS = exports.LAST_GENERATED = exports.DISCOVERIES = exports.ALERTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS = alertsCount => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.summaryCount.alertsLabel', {
  defaultMessage: `{alertsCount} {alertsCount, plural, =1 {alert} other {alerts}}`,
  values: {
    alertsCount
  }
});

/** For displaying alert counts where the exact count is unknown */
exports.ALERTS = ALERTS;
const PLUS_ALERTS = alertsCount => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.summaryCount.plusAlertsLabel', {
  defaultMessage: `{alertsCount}+ alerts`,
  values: {
    alertsCount
  }
});
exports.PLUS_ALERTS = PLUS_ALERTS;
const DISCOVERIES = attackDiscoveriesCount => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.summaryCount.discoveriesLabel', {
  defaultMessage: `{attackDiscoveriesCount} {attackDiscoveriesCount, plural, =1 {discovery} other {discoveries}}`,
  values: {
    attackDiscoveriesCount
  }
});
exports.DISCOVERIES = DISCOVERIES;
const LAST_GENERATED = exports.LAST_GENERATED = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.summaryCount.lastGeneratedLabel', {
  defaultMessage: 'Generated'
});