"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateQueryInFormButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdateQueryInFormButton = ({
  query
}) => {
  const {
    codeBlockRef
  } = (0, _elasticAssistant.useAssistantContext)();
  const handleClick = () => {
    var _codeBlockRef$current;
    codeBlockRef === null || codeBlockRef === void 0 ? void 0 : (_codeBlockRef$current = codeBlockRef.current) === null || _codeBlockRef$current === void 0 ? void 0 : _codeBlockRef$current.call(codeBlockRef, query);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "update-query-in-form-button",
    "aria-label": _translations.UPDATE_QUERY_IN_FORM_TOOLTIP,
    onClick: handleClick,
    color: "text",
    flush: "both",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: _translations.UPDATE_QUERY_IN_FORM_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documentEdit"
  })));
};
exports.UpdateQueryInFormButton = UpdateQueryInFormButton;
UpdateQueryInFormButton.displayName = 'UpdateQueryInFormButton';