"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PinnedEventBaseResponseBody = exports.PersistPinnedEventRouteResponse = exports.PersistPinnedEventRouteRequestBody = exports.PersistPinnedEventResponse = void 0;
var _zod = require("@kbn/zod");
var _components = require("../model/components.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Elastic Security - Timeline - pinned event API
 *   version: 2023-10-31
 */

const PinnedEventBaseResponseBody = exports.PinnedEventBaseResponseBody = _zod.z.object({
  code: _zod.z.number(),
  message: _zod.z.string().optional()
});
const PersistPinnedEventResponse = exports.PersistPinnedEventResponse = _zod.z.union([_components.PinnedEvent.merge(PinnedEventBaseResponseBody), _zod.z.object({}).nullable()]);
const PersistPinnedEventRouteRequestBody = exports.PersistPinnedEventRouteRequestBody = _zod.z.object({
  /**
   * The `_id` of the associated event for this pinned event.
   */
  eventId: _zod.z.string(),
  /**
   * The `savedObjectId` of the timeline that you want this pinned event unpinned from.
   */
  timelineId: _zod.z.string(),
  /**
   * The `savedObjectId` of the pinned event you want to unpin.
   */
  pinnedEventId: _zod.z.string().nullable().optional()
});
const PersistPinnedEventRouteResponse = exports.PersistPinnedEventRouteResponse = _zod.z.object({
  data: _zod.z.object({
    persistPinnedEventOnTimeline: PersistPinnedEventResponse
  })
});