"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleTypeSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRuleTypeSelector = ({
  onChange,
  selectedId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
  legend: "Action Type",
  className: "eui-displayInlineBlock",
  options: [{
    'data-test-subj': 'searchQueryRulesQueryRuleActionTypePinned',
    id: 'pinned',
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pin",
      size: "m"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionType.pinned",
      defaultMessage: "Pinned"
    }))
  }, {
    'data-test-subj': 'searchQueryRulesQueryRuleActionTypeExclude',
    id: 'exclude',
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "eyeClosed",
      size: "m"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionType.exclude",
      defaultMessage: "Exclude"
    }))
  }],
  onChange: id => {
    onChange(id);
  },
  buttonSize: "compressed",
  type: "single",
  idSelected: selectedId
});
exports.QueryRuleTypeSelector = QueryRuleTypeSelector;