"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.byValueToSavedSearch = void 0;
var _get_saved_searches = require("../../../common/service/get_saved_searches");
var _create_get_saved_search_deps = require("./create_get_saved_search_deps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const byValueToSavedSearch = async (result, services, serializable) => {
  var _result$metaInfo;
  const {
    sharingSavedObjectProps,
    managed
  } = (_result$metaInfo = result.metaInfo) !== null && _result$metaInfo !== void 0 ? _result$metaInfo : {};
  return await (0, _get_saved_searches.convertToSavedSearch)({
    ...splitReferences(result.attributes),
    savedSearchId: undefined,
    sharingSavedObjectProps,
    managed
  }, (0, _create_get_saved_search_deps.createGetSavedSearchDeps)(services), serializable);
};
exports.byValueToSavedSearch = byValueToSavedSearch;
const splitReferences = attributes => {
  var _attrs$description;
  const {
    references,
    ...attrs
  } = attributes;
  return {
    references,
    attributes: {
      ...attrs,
      description: (_attrs$description = attrs.description) !== null && _attrs$description !== void 0 ? _attrs$description : ''
    }
  };
};