"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/inspector-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _constants = require("./constants");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => {
  return Boolean(api) && (0, _public.apiHasInspectorAdapters)(api);
};
class InspectPanelAction {
  // right after Explore in Discover which is 20

  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_INSPECT_PANEL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_INSPECT_PANEL);
    (0, _defineProperty2.default)(this, "order", 19);
  }
  getDisplayName() {
    return _i18n.i18n.translate('presentationPanel.action.inspectPanel.displayName', {
      defaultMessage: 'Inspect'
    });
  }
  getIconType() {
    return 'inspect';
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) return false;
    return _kibana_services.inspector.isAvailable(embeddable.getInspectorAdapters());
  }
  async execute({
    embeddable
  }) {
    var _embeddable$parentApi;
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    const adapters = embeddable.getInspectorAdapters();
    if (!(await this.isCompatible({
      embeddable
    })) || adapters === undefined) {
      throw new _public2.IncompatibleActionError();
    }
    const panelTitle = (0, _presentationPublishing.getTitle)(embeddable) || _i18n.i18n.translate('presentationPanel.action.inspectPanel.untitledEmbeddableFilename', {
      defaultMessage: '[No Title]'
    });
    const session = _kibana_services.inspector.open(adapters, {
      title: panelTitle,
      options: {
        fileName: panelTitle
      }
    });
    session.onClose.finally(() => {
      if ((0, _presentationContainers.tracksOverlays)(embeddable.parentApi)) embeddable.parentApi.clearOverlays();
    });

    // send the overlay ref to the parent API if it is capable of tracking overlays
    if ((0, _presentationContainers.tracksOverlays)(embeddable.parentApi)) (_embeddable$parentApi = embeddable.parentApi) === null || _embeddable$parentApi === void 0 ? void 0 : _embeddable$parentApi.openOverlay(session);
  }
}
exports.InspectPanelAction = InspectPanelAction;