"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDataReceivedTelemetryEventEmitter = void 0;
var _common = require("@kbn/logs-explorer-plugin/common");
var _telemetry_events = require("../../../../common/telemetry_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function guardContextHasLogsExplorerState(context) {
  return 'logsExplorerState' in context;
}
const createDataReceivedTelemetryEventEmitter = analytics => (context, event) => {
  if (event.type === 'LOGS_EXPLORER_DATA_RECEIVED' && 'rowCount' in event && event.rowCount > 0 && guardContextHasLogsExplorerState(context)) {
    const selectedIntegrationName = _common.singleDatasetSelectionPlainRT.is(context.logsExplorerState.dataSourceSelection) ? context.logsExplorerState.dataSourceSelection.selection.name : undefined;
    analytics.reportEvent(_telemetry_events.DATA_RECEIVED_TELEMETRY_EVENT.eventType, {
      rowCount: event.rowCount,
      selectedIntegrationName
    });
  }
};
exports.createDataReceivedTelemetryEventEmitter = createDataReceivedTelemetryEventEmitter;