"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupModeBadge = SetupModeBadge;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const clickToMonitorWithMetricbeat = _i18n.i18n.translate('xpack.monitoring.setupMode.clickToMonitorWithMetricbeat', {
  defaultMessage: 'Monitor with Metricbeat'
});
const clickToDisableInternalCollection = _i18n.i18n.translate('xpack.monitoring.setupMode.clickToDisableInternalCollection', {
  defaultMessage: 'Disable self monitoring'
});
const monitoredWithMetricbeat = _i18n.i18n.translate('xpack.monitoring.setupMode.usingMetricbeatCollection', {
  defaultMessage: 'Monitored with Metricbeat'
});
const unknown = _i18n.i18n.translate('xpack.monitoring.setupMode.unknown', {
  defaultMessage: 'N/A'
});
function SetupModeBadge({
  setupMode,
  productName,
  status,
  instance,
  clusterUuid
}) {
  let customAction = null;
  let customText = null;
  const setupModeData = setupMode.data || {};
  const setupModeMeta = setupMode.meta || {};

  // Migrating from partially to fully for Elasticsearch involves changing a cluster
  // setting which impacts all nodes in the cluster so the action text needs to reflect that
  const allPartiallyMigrated = setupModeData.totalUniquePartiallyMigratedCount === setupModeData.totalUniqueInstanceCount;
  if (status.isPartiallyMigrated && productName === _constants.ELASTICSEARCH_SYSTEM_ID) {
    if (allPartiallyMigrated) {
      customText = clickToDisableInternalCollection;
      if (setupModeMeta.liveClusterUuid === clusterUuid) {
        customAction = setupMode.shortcutToFinishMigration;
      }
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "flag"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "warning"
      }, _i18n.i18n.translate('xpack.monitoring.setupMode.monitorAllNodes', {
        defaultMessage: 'Some nodes use only self monitoring'
      })));
    }
  }
  const badgeProps = {};
  if (status.isInternalCollector || status.isPartiallyMigrated || status.isNetNewUser) {
    badgeProps.onClick = customAction ? customAction : () => setupMode.openFlyout(instance);
  }
  let statusText = null;
  if (status.isInternalCollector) {
    if (badgeProps.onClick) {
      badgeProps.onClickAriaLabel = customText || clickToMonitorWithMetricbeat;
    }
    statusText = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "danger",
      iconType: "flag"
    }, badgeProps), customText || clickToMonitorWithMetricbeat);
  } else if (status.isPartiallyMigrated) {
    if (badgeProps.onClick) {
      badgeProps.onClickAriaLabel = customText || clickToDisableInternalCollection;
    }
    statusText = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "warning",
      iconType: "flag"
    }, badgeProps), customText || clickToDisableInternalCollection);
  } else if (status.isFullyMigrated) {
    if (badgeProps.onClick) {
      badgeProps.onClickAriaLabel = customText || monitoredWithMetricbeat;
    }
    statusText = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "primary",
      iconType: "flag"
    }, badgeProps), customText || monitoredWithMetricbeat);
  } else if (status.isNetNewUser) {
    if (badgeProps.onClick) {
      badgeProps.onClickAriaLabel = customText || clickToMonitorWithMetricbeat;
    }
    statusText = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "danger",
      iconType: "flag"
    }, badgeProps), customText || clickToMonitorWithMetricbeat);
  } else {
    if (badgeProps.onClick) {
      badgeProps.onClickAriaLabel = customText || unknown;
    }
    statusText = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "danger",
      iconType: "flag"
    }, badgeProps), customText || unknown);
  }
  return statusText;
}