"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _check_capabilities = require("../../capabilities/check_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpgradeWarning = () => {
  const isUpgradeInProgress = (0, _check_capabilities.useUpgradeCheck)();
  if (isUpgradeInProgress === true) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.upgrade.upgradeWarning.upgradeInProgressWarningTitle",
        defaultMessage: "Index migration in progress"
      }),
      color: "warning",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.upgrade.upgradeWarning.upgradeInProgressWarningDescription",
      defaultMessage: "Indices related to Machine Learning are currently being upgraded."
    }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.upgrade.upgradeWarning.upgradeInProgressWarningDescriptionExtra",
      defaultMessage: "Some actions will not be available during this time."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  return null;
};
exports.UpgradeWarning = UpgradeWarning;