"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDisabledByMessage = getDisabledByMessage;
exports.getVectorStyleLabel = getVectorStyleLabel;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDisabledByMessage(styleName) {
  return _i18n.i18n.translate('xpack.maps.styles.vector.disabledByMessage', {
    defaultMessage: `Set ''{styleLabel}'' to enable`,
    values: {
      styleLabel: getVectorStyleLabel(styleName)
    }
  });
}
function getVectorStyleLabel(styleName) {
  switch (styleName) {
    case _constants.VECTOR_STYLES.FILL_COLOR:
      return _i18n.i18n.translate('xpack.maps.styles.vector.fillColorLabel', {
        defaultMessage: 'Fill color'
      });
    case _constants.VECTOR_STYLES.LINE_COLOR:
      return _i18n.i18n.translate('xpack.maps.styles.vector.borderColorLabel', {
        defaultMessage: 'Border color'
      });
    case _constants.VECTOR_STYLES.LINE_WIDTH:
      return _i18n.i18n.translate('xpack.maps.styles.vector.borderWidthLabel', {
        defaultMessage: 'Border width'
      });
    case _constants.VECTOR_STYLES.ICON:
      return _i18n.i18n.translate('xpack.maps.styles.vector.iconLabel', {
        defaultMessage: 'Icon'
      });
    case _constants.VECTOR_STYLES.ICON_SIZE:
      return _i18n.i18n.translate('xpack.maps.styles.vector.symbolSizeLabel', {
        defaultMessage: 'Symbol size'
      });
    case _constants.VECTOR_STYLES.ICON_ORIENTATION:
      return _i18n.i18n.translate('xpack.maps.styles.vector.orientationLabel', {
        defaultMessage: 'Symbol orientation'
      });
    case _constants.VECTOR_STYLES.LABEL_TEXT:
      return _i18n.i18n.translate('xpack.maps.styles.vector.labelLabel', {
        defaultMessage: 'Label'
      });
    case _constants.VECTOR_STYLES.LABEL_ZOOM_RANGE:
      return _i18n.i18n.translate('xpack.maps.styles.vector.labelZoomRangeLabel', {
        defaultMessage: 'Label visibility'
      });
    case _constants.VECTOR_STYLES.LABEL_COLOR:
      return _i18n.i18n.translate('xpack.maps.styles.vector.labelColorLabel', {
        defaultMessage: 'Label color'
      });
    case _constants.VECTOR_STYLES.LABEL_SIZE:
      return _i18n.i18n.translate('xpack.maps.styles.vector.labelSizeLabel', {
        defaultMessage: 'Label size'
      });
    case _constants.VECTOR_STYLES.LABEL_BORDER_COLOR:
      return _i18n.i18n.translate('xpack.maps.styles.vector.labelBorderColorLabel', {
        defaultMessage: 'Label border color'
      });
    case _constants.VECTOR_STYLES.LABEL_BORDER_SIZE:
      return _i18n.i18n.translate('xpack.maps.styles.vector.labelBorderWidthLabel', {
        defaultMessage: 'Label border width'
      });
    case _constants.VECTOR_STYLES.LABEL_POSITION:
      return _i18n.i18n.translate('xpack.maps.styles.vector.labelPositionLabel', {
        defaultMessage: 'Label position'
      });
    default:
      return styleName;
  }
}