"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityIndexPatterns = getSecurityIndexPatterns;
var _minimatch = _interopRequireDefault(require("minimatch"));
var _kibana_services = require("../../../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

async function getSecurityIndexPatterns() {
  const uiSettings = (0, _kibana_services.getUiSettings)();
  let securityIndexPatternTitles;
  try {
    securityIndexPatternTitles = uiSettings.get('securitySolution:defaultIndex');
  } catch (error) {
    // UiSettings throws with unreconized configuration setting
    // siem:defaultIndex configuration setting is not registered if security app is not running
    return [];
  }
  const indexPatternCache = await (0, _kibana_services.getIndexPatternService)().getCache();
  return indexPatternCache.filter(savedObject => {
    return securityIndexPatternTitles.some(indexPatternTitle => savedObject.attributes.title.split(',').some(pattern => (0, _minimatch.default)(indexPatternTitle, pattern)));
  }).map(savedObject => {
    return {
      id: savedObject.id,
      title: savedObject.attributes.title
    };
  });
}