"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _ecs_routes = require("./ecs_routes");
var _build_integration_routes = require("./build_integration_routes");
var _categorization_routes = require("./categorization_routes");
var _related_routes = require("./related_routes");
var _pipeline_routes = require("./pipeline_routes");
var _analyze_logs_routes = require("./analyze_logs_routes");
var _cel_routes = require("./cel_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoutes(router, experimentalFeatures) {
  (0, _analyze_logs_routes.registerAnalyzeLogsRoutes)(router);
  (0, _ecs_routes.registerEcsRoutes)(router);
  (0, _build_integration_routes.registerIntegrationBuilderRoutes)(router);
  (0, _categorization_routes.registerCategorizationRoutes)(router);
  (0, _related_routes.registerRelatedRoutes)(router);
  (0, _pipeline_routes.registerPipelineRoutes)(router);
  if (experimentalFeatures.generateCel) {
    (0, _cel_routes.registerCelInputRoutes)(router);
  }
}