"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleReview = handleReview;
var _output_parsers = require("@langchain/core/output_parsers");
var _processors = require("../../util/processors");
var _prompts = require("./prompts");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleReview({
  state,
  model
}) {
  const relatedReviewPrompt = _prompts.RELATED_REVIEW_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const relatedReviewGraph = relatedReviewPrompt.pipe(model).pipe(outputParser);
  const currentProcessors = await relatedReviewGraph.invoke({
    current_processors: JSON.stringify(state.currentProcessors, null, 2),
    ex_answer: state.exAnswer,
    previous_error: state.previousError,
    pipeline_results: JSON.stringify(state.pipelineResults.map(_util.deepCopySkipArrays), null, 2)
  });
  const processors = {
    type: 'related',
    processors: currentProcessors
  };
  const currentPipeline = (0, _processors.combineProcessors)(state.initialPipeline, processors);
  return {
    currentPipeline,
    currentProcessors,
    reviewed: true,
    lastExecutedChain: 'review'
  };
}