"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCelGraph = getCelGraph;
var _langgraph = require("@langchain/langgraph");
var _build_program = require("./build_program");
var _retrieve_state_details = require("./retrieve_state_details");
var _retrieve_state_vars = require("./retrieve_state_vars");
var _summarize_query = require("./summarize_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  apiDefinition: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  apiQuerySummary: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  exampleCelPrograms: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  currentProgram: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  stateVarNames: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  stateSettings: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  redactVars: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  }
};
function modelInput({
  state
}) {
  return {
    finalized: false,
    lastExecutedChain: 'modelInput',
    apiDefinition: state.apiDefinition,
    dataStreamName: state.dataStreamName
  };
}
function modelOutput({
  state
}) {
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      program: state.currentProgram,
      stateSettings: state.stateSettings,
      redactVars: state.redactVars
    }
  };
}
async function getCelGraph({
  model
}) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', state => modelInput({
    state
  })).addNode('handleSummarizeQuery', state => (0, _summarize_query.handleSummarizeQuery)({
    state,
    model
  })).addNode('handleBuildProgram', state => (0, _build_program.handleBuildProgram)({
    state,
    model
  })).addNode('handleGetStateVariables', state => (0, _retrieve_state_vars.handleGetStateVariables)({
    state,
    model
  })).addNode('handleGetStateDetails', state => (0, _retrieve_state_details.handleGetStateDetails)({
    state,
    model
  })).addNode('modelOutput', state => modelOutput({
    state
  })).addEdge(_langgraph.START, 'modelInput').addEdge('modelOutput', _langgraph.END).addEdge('modelInput', 'handleSummarizeQuery').addEdge('handleSummarizeQuery', 'handleBuildProgram').addEdge('handleBuildProgram', 'handleGetStateVariables').addEdge('handleGetStateVariables', 'handleGetStateDetails').addEdge('handleGetStateDetails', 'modelOutput');
  const compiledCelGraph = workflow.compile();
  return compiledCelGraph;
}