"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.httpResponseIntoObservable = httpResponseIntoObservable;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _create_observable_from_http_response = require("./create_observable_from_http_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function httpResponseIntoObservable() {
  return (0, _rxjs.pipe)((0, _rxjs.switchMap)(response => (0, _create_observable_from_http_response.createObservableFromHttpResponse)(response)), (0, _rxjs.catchError)(error => {
    return (0, _rxjs.throwError)(() => (0, _inferenceCommon.createInferenceInternalError)(error.message));
  }), (0, _rxjs.map)(line => {
    try {
      return JSON.parse(line);
    } catch (error) {
      throw (0, _inferenceCommon.createInferenceInternalError)(`Failed to parse JSON`);
    }
  }), (0, _rxjs.tap)(event => {
    if (event.type === _inferenceCommon.InferenceTaskEventType.error) {
      const errorEvent = event;
      throw new _inferenceCommon.InferenceTaskError(errorEvent.error.code, errorEvent.error.message, errorEvent.error.meta);
    }
  }));
}