"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBufferExtractor = getBufferExtractor;
exports.untarBuffer = untarBuffer;
exports.unzipBuffer = unzipBuffer;
var _promises = require("stream/promises");
var tar = _interopRequireWildcard(require("tar"));
var _yauzl = _interopRequireDefault(require("yauzl"));
var _streams = require("../streams");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function untarBuffer(buffer, filter = entry => true, onEntry = async entry => {}, shouldReadBuffer) {
  const deflatedStream = (0, _streams.bufferToStream)(buffer);
  // use tar.list vs .extract to avoid writing to disk
  const inflateStream = tar.list().on('entry', entry => {
    const path = entry.path || '';
    if (!filter({
      path
    })) return;
    if (shouldReadBuffer && !shouldReadBuffer(path)) {
      return onEntry({
        path
      }).catch(() => {});
    }
    (0, _streams.streamToBuffer)(entry).then(entryBuffer => onEntry({
      buffer: entryBuffer,
      path
    })).catch(() => {});
  });
  deflatedStream.pipe(inflateStream);
  await (0, _promises.finished)(inflateStream);
}
async function unzipBuffer(buffer, filter = entry => true, onEntry = async entry => {}, shouldReadBuffer) {
  const zipfile = await yauzlFromBuffer(buffer, {
    lazyEntries: true
  });
  zipfile.readEntry();
  zipfile.on('entry', async entry => {
    const path = entry.fileName;
    if (!filter({
      path
    })) return zipfile.readEntry();
    try {
      if (shouldReadBuffer && !shouldReadBuffer(path)) {
        return onEntry({
          path
        });
      }
      const entryBuffer = await getZipReadStream(zipfile, entry).then(_streams.streamToBuffer);
      await onEntry({
        buffer: entryBuffer,
        path
      });
    } finally {
      zipfile.readEntry();
    }
  });
  return new Promise((resolve, reject) => zipfile.on('end', resolve).on('error', reject));
}
function getBufferExtractor(args) {
  if ('contentType' in args) {
    if (args.contentType === 'application/gzip') {
      return untarBuffer;
    } else if (args.contentType === 'application/zip') {
      return unzipBuffer;
    }
  } else if ('archivePath' in args) {
    if (args.archivePath.endsWith('.zip')) {
      return unzipBuffer;
    }
    if (args.archivePath.endsWith('.gz')) {
      return untarBuffer;
    }
  }
}
function yauzlFromBuffer(buffer, opts) {
  return new Promise((resolve, reject) => _yauzl.default.fromBuffer(buffer, opts, (err, handle) => err ? reject(err) : resolve(handle)));
}
function getZipReadStream(zipfile, entry) {
  return new Promise((resolve, reject) => zipfile.openReadStream(entry, (err, readStream) => err ? reject(err) : resolve(readStream)));
}