"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecretFormRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecretFormRow = ({
  fullWidth,
  error,
  isInvalid,
  children,
  clear,
  title,
  initialValue,
  onToggleSecretStorage,
  cancelEdit,
  useSecretsStorage,
  isConvertedToSecret = false,
  label,
  disabled
}) => {
  const hasInitialValue = !!initialValue;
  const [editMode, setEditMode] = (0, _react.useState)(isConvertedToSecret || !initialValue);
  const valueHiddenPanel = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false
  }, disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.outputForm.secretValueHiddenAndDisabledMessage",
    defaultMessage: "The saved {varName} is hidden.",
    values: {
      varName: title
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.outputForm.secretValueHiddenMessage",
    defaultMessage: "The saved {varName} is hidden. You can only replace the {varName}.",
    values: {
      varName: title
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setEditMode(true),
    color: "primary",
    iconType: "refresh",
    iconSide: "left",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.outputForm.editSecretValue",
    defaultMessage: "Replace {varName}",
    values: {
      varName: title
    }
  }))));
  const cancelButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      setEditMode(false);
      if (cancelEdit) cancelEdit();
    },
    color: "primary",
    iconType: "refresh",
    iconSide: "left",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.stepConfigure.fieldSecretValueSetCancelButton",
    defaultMessage: "Cancel {varName} change",
    values: {
      varName: title
    }
  }));
  const editValue = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, hasInitialValue && !isConvertedToSecret && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    "data-test-subj": "secretCancelChangeBtn"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, cancelButton)));
  const secretLabel = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "lock",
    "data-test-subj": "lockIcon"
  }), "\xA0", title, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTooltip', {
      defaultMessage: 'This value will be stored as a secret, meaning once saved the value cannot be viewed again'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "question"
  })));
  const helpText = (0, _react.useMemo)(() => {
    if (disabled) return null;
    if (isConvertedToSecret) return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslKeySecretInputConvertedCalloutTitle",
      defaultMessage: "This field will be re-saved using secret storage from plain text storage. Secrets storage requires Fleet Server v8.12.0 and above. {revertLink}",
      values: {
        revertLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => onToggleSecretStorage(false),
          color: "primary"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.editOutputFlyout.revertToPlaintextLink",
          defaultMessage: "Click to use plain text storage instead"
        }))
      }
    }));
    if (!initialValue) return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslKeySecretInputCalloutTitle",
      defaultMessage: "This field uses secret storage and requires Fleet Server v8.12.0 and above. {revertLink}",
      values: {
        revertLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => onToggleSecretStorage(false),
          color: "primary"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.editOutputFlyout.revertToPlaintextLink",
          defaultMessage: "Click to use plain text storage instead"
        }))
      }
    });
    return undefined;
  }, [disabled, initialValue, isConvertedToSecret, onToggleSecretStorage]);
  const plainTextHelp = disabled ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.secretInputCalloutTitle",
    defaultMessage: "This field should be stored as a secret, currently it is set to be stored as plain text. {enableSecretLink}",
    values: {
      enableSecretLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => onToggleSecretStorage(true),
        color: "primary"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.editOutputFlyout.revertToSecretStorageLink",
        defaultMessage: "Click to use secret storage instead"
      }))
    }
  });
  const inputComponent = editMode ? editValue : valueHiddenPanel;
  return useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: fullWidth,
    label: secretLabel,
    error: error,
    isInvalid: isInvalid,
    helpText: helpText
  }, inputComponent) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: fullWidth,
    error: error,
    isInvalid: isInvalid,
    label: label,
    helpText: plainTextHelp
  }, inputComponent);
};
exports.SecretFormRow = SecretFormRow;