"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiPageStepsLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../components");
var _services = require("../../../../../services");
var _components2 = require("../../../../../components");
var _layouts = require("../../../../../layouts");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiPageStepsLayout = props => {
  const {
    packageInfo,
    integrationInfo,
    steps,
    currentStep,
    error
  } = props;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_components2.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information"
      }),
      error: error
    });
  }
  const StepComponent = steps[currentStep].component;
  const topContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.multiPageTitle",
    defaultMessage: "Set up {title} integration",
    values: {
      title: packageInfo.title
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_.PageSteps, {
    currentStep: currentStep,
    steps: steps.map(s => s.title)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }));
  const maxWidth = 866;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    topContent: topContent,
    restrictHeaderWidth: maxWidth,
    restrictWidth: maxWidth
  }, /*#__PURE__*/_react.default.createElement(StepComponent, props), packageInfo && /*#__PURE__*/_react.default.createElement(_components.IntegrationBreadcrumb, {
    pkgTitle: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title,
    pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo),
    integration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name
  }));
};
exports.MultiPageStepsLayout = MultiPageStepsLayout;