"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaFieldsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _schema = require("../../../../../shared/schema");
var _constants = require("./constants");
var _schema_logic = require("./schema_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaFieldsTable = () => {
  const {
    updateExistingFieldType
  } = (0, _kea.useActions)(_schema_logic.SchemaLogic);
  const {
    filteredSchemaFields,
    filterValue
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  return Object.keys(filteredSchemaFields).length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    tableLayout: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants.SCHEMA_ERRORS_TABLE_FIELD_NAME_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "right",
    id: "schemaDataType"
  }, _constants.SCHEMA_ERRORS_TABLE_DATA_TYPE_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, Object.keys(filteredSchemaFields).map(fieldName => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: fieldName,
    "data-test-subj": "SchemaFieldRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("strong", null, fieldName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "right"
  }, /*#__PURE__*/_react.default.createElement(_schema.SchemaFieldTypeSelect, {
    disabled: fieldName === 'id',
    fieldName: fieldName,
    fieldType: filteredSchemaFields[fieldName],
    updateExistingFieldType: updateExistingFieldType,
    "aria-labelledby": "schemaDataType"
  })))))) : /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "NoResultsMessage"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.schema.filter.noResults.message', {
    defaultMessage: 'No results found for "{filterValue}".',
    values: {
      filterValue
    }
  }));
};
exports.SchemaFieldsTable = SchemaFieldsTable;