"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationActionsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _curation_suggestion_logic = require("./curation_suggestion_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationActionsPopover = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    acceptSuggestion,
    acceptAndAutomateSuggestion,
    rejectSuggestion,
    rejectAndDisableSuggestion
  } = (0, _kea.useActions)(_curation_suggestion_logic.CurationSuggestionLogic);
  const onButtonClick = () => setIsPopoverOpen(!isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "boxesVertical",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.actionsPopoverAriaLabel', {
      defaultMessage: 'More suggestion actions'
    }),
    color: "text",
    onClick: onButtonClick
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.actionsPopoverTitle', {
    defaultMessage: 'Manage suggestion'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    size: "xs",
    iconType: "check",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.actionsAcceptButtonLabel', {
      defaultMessage: 'Accept this suggestion'
    }),
    onClick: acceptSuggestion,
    "data-test-subj": "acceptButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    size: "xs",
    iconType: "check",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.actionsAutomateButtonLabel', {
      defaultMessage: 'Automate - always accept new suggestions for this query'
    }),
    onClick: acceptAndAutomateSuggestion,
    "data-test-subj": "automateButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    size: "xs",
    iconType: "cross",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.actionsRejectButtonLabel', {
      defaultMessage: 'Reject this suggestion'
    }),
    onClick: rejectSuggestion,
    "data-test-subj": "rejectButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    size: "xs",
    iconType: "bellSlash",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestedCuration.actionsTurnOffButtonLabel', {
      defaultMessage: 'Reject and turn off suggestions for this query'
    }),
    onClick: rejectAndDisableSuggestion,
    "data-test-subj": "turnoffButton"
  })));
};
exports.CurationActionsPopover = CurationActionsPopover;