"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlParams = useUrlParams;
var _react = require("react");
var _queryString = require("query-string");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses `search` params and returns an object with them along with a `toUrlParams` function
 * that allows being able to retrieve a stringified version of an object (default is the
 * `urlParams` that was parsed) for use in the url.
 * Object will be recreated every time `search` changes.
 */
function useUrlParams() {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  return (0, _react.useMemo)(() => {
    const urlParams = (0, _queryString.parse)(search);
    return {
      urlParams,
      toUrlParams: (params = urlParams) => (0, _queryString.stringify)(params)
    };
  }, [search]);
}