"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchConnectorsSo = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchConnectorsSo = async ({
  esClient,
  kibanaIndices,
  aggs
}) => {
  return esClient.search({
    index: kibanaIndices,
    ignore_unavailable: true,
    body: {
      aggs,
      size: 0,
      query: {
        match_all: {}
      }
    }
  });
};
exports.searchConnectorsSo = searchConnectorsSo;