"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createJWKSManager = exports.createJWKS = exports.JWKSManager = exports.RSA_ALGORITHM = void 0;
var jose = require("node-jose");
exports.RSA_ALGORITHM = 'RSA-OAEP';
var JWKSManager = /** @class */ (function () {
    function JWKSManager(store, jwk, jwe) {
        if (jwk === void 0) { jwk = jose.JWK; }
        if (jwe === void 0) { jwe = jose.JWE; }
        this.store = store;
        this.JWK = jwk;
        this.JWE = jwe;
    }
    JWKSManager.prototype.addKey = function (kid, modulus, use) {
        return __awaiter(this, void 0, void 0, function () {
            var keyConfig, privateKey;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        keyConfig = { alg: exports.RSA_ALGORITHM, use: use, kid: kid };
                        return [4 /*yield*/, this.JWK.createKey('RSA', modulus, keyConfig)];
                    case 1:
                        privateKey = _a.sent();
                        return [4 /*yield*/, this.insertKey(privateKey)];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    JWKSManager.prototype.insertKey = function (jwk) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.store.add(jwk)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    JWKSManager.prototype.getPublicJWK = function (kid) {
        var jwk = this.getKey(kid);
        if (!jwk) {
            return null;
        }
        return jwk.toJSON();
    };
    JWKSManager.prototype.getPrivateJWK = function (kid) {
        var jwk = this.getKey(kid);
        if (!jwk) {
            return null;
        }
        return jwk.toJSON(true);
    };
    JWKSManager.prototype.getPublicJWKS = function () {
        return this.store.toJSON();
    };
    JWKSManager.prototype.getPrivateJWKS = function () {
        return this.store.toJSON(true);
    };
    JWKSManager.prototype.removeKey = function (key) {
        return this.store.remove(key);
    };
    JWKSManager.prototype.encrypt = function (kid, input) {
        return __awaiter(this, void 0, void 0, function () {
            var publicJWK;
            return __generator(this, function (_a) {
                publicJWK = this.getKey(kid);
                if (!publicJWK) {
                    throw Error("Missing kid (".concat(kid, ")."));
                }
                return [2 /*return*/, this.JWE.createEncrypt({ format: 'compact', zip: true }, publicJWK)
                        .update(input)
                        .final()];
            });
        });
    };
    JWKSManager.prototype.decrypt = function (payload, jwks) {
        if (jwks === void 0) { jwks = this.store; }
        return __awaiter(this, void 0, void 0, function () {
            var decrypter;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        decrypter = this.JWE.createDecrypt(jwks);
                        return [4 /*yield*/, decrypter.decrypt(payload)];
                    case 1: return [2 /*return*/, (_a.sent())];
                }
            });
        });
    };
    JWKSManager.prototype.getKey = function (kid) {
        return this.store.get(kid);
    };
    return JWKSManager;
}());
exports.JWKSManager = JWKSManager;
function createJWKS(jwk, jwks) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            if (jwks) {
                return [2 /*return*/, jwk.asKeyStore(jwks)];
            }
            return [2 /*return*/, jwk.createKeyStore()];
        });
    });
}
exports.createJWKS = createJWKS;
function createJWKSManager(jwks) {
    return __awaiter(this, void 0, void 0, function () {
        var store;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, createJWKS(jose.JWK, jwks)];
                case 1:
                    store = _a.sent();
                    return [2 /*return*/, new JWKSManager(store, jose.JWK)];
            }
        });
    });
}
exports.createJWKSManager = createJWKSManager;
//# sourceMappingURL=jwks.js.map