"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildAreaStyles = buildAreaStyles;
const color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
const common_1 = require("../../../../../utils/common");
const texture_1 = require("../../../utils/texture");
function buildAreaStyles(ctx, imgCanvas, seriesColor, themeAreaStyle, highlightState) {
    const isDimmed = highlightState === 'dimmed';
    const fillColor = isDimmed && 'fill' in themeAreaStyle.dimmed ? themeAreaStyle.dimmed.fill : seriesColor;
    const opacity = isDimmed && 'opacity' in themeAreaStyle.dimmed
        ? themeAreaStyle.dimmed.opacity * themeAreaStyle.opacity
        : themeAreaStyle.opacity;
    const texture = themeAreaStyle.texture
        ? (0, texture_1.getTextureStyles)(ctx, imgCanvas, seriesColor, 1, getTextureStyleFromFocusState(themeAreaStyle.texture, themeAreaStyle.dimmed, highlightState))
        : undefined;
    const color = (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)((0, common_1.getColorFromVariant)(fillColor, themeAreaStyle.fill)), (currentColorOpacity) => currentColorOpacity * opacity);
    return {
        color,
        texture,
    };
}
function getTextureStyleFromFocusState(textureStyle, themeDimmedStyle, highlightState) {
    if (highlightState !== 'dimmed') {
        return textureStyle;
    }
    if ('opacity' in themeDimmedStyle) {
        return {
            ...textureStyle,
            opacity: (textureStyle.opacity ?? 1) * themeDimmedStyle.opacity,
        };
    }
    return {
        ...textureStyle,
        opacity: themeDimmedStyle.texture.opacity,
    };
}
//# sourceMappingURL=area.js.map