"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesCallOutBody = exports.MISSING_PRIVILEGES_CALLOUT_TITLE = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _comma_separated_values = require("../../../detections/components/callouts/missing_privileges_callout/comma_separated_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MISSING_PRIVILEGES_CALLOUT_TITLE = exports.MISSING_PRIVILEGES_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageTitle', {
  defaultMessage: 'Insufficient privileges'
});
const MissingPrivilegesCallOutBody = ({
  indexPrivileges,
  clusterPrivileges
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.messageDetail",
    defaultMessage: "{essence} {indexPrivileges} {clusterPrivileges} ",
    values: {
      essence: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.essenceDescription",
        defaultMessage: "You need the following privileges to fully access this functionality. Contact your administrator for further assistance. Read more about {docs}.",
        values: {
          docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.securitySolution.entityAnalytics.riskScorePrerequisites,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.riskEngineRequirementsDocLink",
            defaultMessage: "Risk Scoring prerequisites"
          }))
        }
      })),
      indexPrivileges: indexPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.indexPrivilegesTitle",
        defaultMessage: "Missing Elasticsearch index privileges:"
      }), /*#__PURE__*/_react.default.createElement("ul", null, indexPrivileges.map(([index, missingPrivileges]) => /*#__PURE__*/_react.default.createElement("li", {
        key: index
      }, missingIndexPrivileges(index, missingPrivileges))))) : null,
      clusterPrivileges: clusterPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.clusterPrivilegesTitle",
        defaultMessage: "Missing Elasticsearch cluster privileges:"
      }), /*#__PURE__*/_react.default.createElement("ul", null, clusterPrivileges.map(privilege => /*#__PURE__*/_react.default.createElement("li", {
        key: privilege
      }, privilege)))) : null
    }
  });
};
exports.MissingPrivilegesCallOutBody = MissingPrivilegesCallOutBody;
const missingIndexPrivileges = (index, privileges) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.missingIndexPrivileges",
  defaultMessage: "Missing {privileges} privileges for the {index} index.",
  values: {
    privileges: /*#__PURE__*/_react.default.createElement(_comma_separated_values.CommaSeparatedValues, {
      values: privileges
    }),
    index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, index)
  }
});