"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostRiskScoreQueryId = exports.FIRST_RECORD_PAGINATION = void 0;
Object.defineProperty(exports, "RISK_SCORE_RANGES", {
  enumerable: true,
  get: function () {
    return _risk_engine.RISK_LEVEL_RANGES;
  }
});
exports.formatRiskScore = exports.UserRiskScoreQueryId = exports.SEVERITY_UI_SORT_ORDER = exports.RISK_SEVERITY_COLOUR = void 0;
var _search_strategy = require("../../../common/search_strategy");
var _utils = require("../../overview/components/detection_response/utils");
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEVERITY_UI_SORT_ORDER = exports.SEVERITY_UI_SORT_ORDER = [_search_strategy.RiskSeverity.Unknown, _search_strategy.RiskSeverity.Low, _search_strategy.RiskSeverity.Moderate, _search_strategy.RiskSeverity.High, _search_strategy.RiskSeverity.Critical];

// Migration to tokens from EUI during the Borealis theme migration is blocked until new severity palette is agreed upon.
// We keep using hardcoded colors until security severity palette is ready https://github.com/elastic/kibana/issues/203387
// TODO: Borealis migration - move from hardcoded values to severity palette, which should instead use shared hook across security:
// https://github.com/elastic/security-team/issues/11516 hook - https://github.com/elastic/kibana/pull/206276
const RISK_SEVERITY_COLOUR = exports.RISK_SEVERITY_COLOUR = {
  [_search_strategy.RiskSeverity.Unknown]: '#aaa',
  // euiThemeVars no longer in use. Hard coded temporarily, see above.
  [_search_strategy.RiskSeverity.Low]: _utils.SEVERITY_COLOR.low,
  [_search_strategy.RiskSeverity.Moderate]: _utils.SEVERITY_COLOR.medium,
  [_search_strategy.RiskSeverity.High]: _utils.SEVERITY_COLOR.high,
  [_search_strategy.RiskSeverity.Critical]: _utils.SEVERITY_COLOR.critical
};

// TODO #173073 @tiansivive Add to utilities in `src/platform/packages/shared/kbn-utility-types`
let UserRiskScoreQueryId = exports.UserRiskScoreQueryId = /*#__PURE__*/function (UserRiskScoreQueryId) {
  UserRiskScoreQueryId["USERS_BY_RISK"] = "UsersByRisk";
  UserRiskScoreQueryId["USER_DETAILS_RISK_SCORE"] = "UserDetailsRiskScore";
  return UserRiskScoreQueryId;
}({});
let HostRiskScoreQueryId = exports.HostRiskScoreQueryId = /*#__PURE__*/function (HostRiskScoreQueryId) {
  HostRiskScoreQueryId["DEFAULT"] = "HostRiskScore";
  HostRiskScoreQueryId["HOST_DETAILS_RISK_SCORE"] = "HostDetailsRiskScore";
  HostRiskScoreQueryId["OVERVIEW_RISKY_HOSTS"] = "OverviewRiskyHosts";
  HostRiskScoreQueryId["HOSTS_BY_RISK"] = "HostsByRisk";
  return HostRiskScoreQueryId;
}({});
/**
 *
 * @returns risk score rounded with 2 digits after the decimal separator
 * @example
 * formatRiskScore(10.555) // '10.56'
 */
const formatRiskScore = riskScore => (Math.round(riskScore * 100) / 100).toFixed(2);
exports.formatRiskScore = formatRiskScore;
const FIRST_RECORD_PAGINATION = exports.FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};