"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NeedAdminForUpdateRulesCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _callouts = require("../../../../common/components/callouts");
var _user_info = require("../../user_info");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const needAdminForUpdateRulesMessage = {
  type: 'primary',
  id: 'need-admin-for-update-rules',
  title: i18n.NEED_ADMIN_CALLOUT_TITLE,
  description: i18n.needAdminForUpdateCallOutBody()
};

/**
 * Callout component that lets the user know that an administrator is needed for performing
 * and auto-update of signals or not. For this component to render the user must:
 * - Have the permissions to be able to read "signalIndexMappingOutdated" and that condition is "true"
 * - Have the permissions to be able to read "hasIndexManage" and that condition is "false"
 *
 * Some users do not have sufficient privileges to be able to determine if "signalIndexMappingOutdated"
 * is outdated or not. Same could apply to "hasIndexManage". When users do not have enough permissions
 * to determine if "signalIndexMappingOutdated" is true or false, the permissions system returns a "null"
 * instead.
 *
 * If the user has the permissions to see that signalIndexMappingOutdated is true and that
 * hasIndexManage is also true, then the user should be performing the update on the page which is
 * why we do not show it for that condition.
 */
const NeedAdminForUpdateCallOutComponent = () => {
  const [{
    signalIndexMappingOutdated,
    hasIndexManage
  }] = (0, _user_info.useUserData)();
  const signalIndexMappingIsOutdated = signalIndexMappingOutdated != null && signalIndexMappingOutdated;
  const userDoesntHaveIndexManage = hasIndexManage != null && !hasIndexManage;
  const shouldShowCallout = signalIndexMappingIsOutdated && userDoesntHaveIndexManage;

  // Passing shouldShowCallout to the condition param will end up with an unecessary spacer being rendered
  return shouldShowCallout ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_callouts.CallOutPersistentSwitcher, {
    condition: true,
    message: needAdminForUpdateRulesMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null;
};
const NeedAdminForUpdateRulesCallOut = exports.NeedAdminForUpdateRulesCallOut = /*#__PURE__*/(0, _react.memo)(NeedAdminForUpdateCallOutComponent);