"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedBuckets = void 0;
var _flatten_bucket = require("./flatten_bucket");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFlattenedBuckets = ({
  buckets,
  maxRiskSubAggregations,
  stackByField0
}) => buckets.flatMap(bucket => (0, _flatten_bucket.flattenBucket)({
  bucket,
  maxRiskSubAggregations
}));
exports.getFlattenedBuckets = getFlattenedBuckets;