"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationFilterButton = exports.INTEGRATION_BUTTON_TEST_ID = exports.INTEGRATIONS_LIST_TEST_ID = exports.FILTER_KEY = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filter = require("../../../utils/filter");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_BUTTON_TEST_ID = exports.INTEGRATION_BUTTON_TEST_ID = 'alert-summary-integration-button';
const INTEGRATIONS_LIST_TEST_ID = exports.INTEGRATIONS_LIST_TEST_ID = 'alert-summary-integrations-list';
const INTEGRATIONS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.alertSummary.integrations.buttonLabel', {
  defaultMessage: 'Integrations'
});
const FILTER_KEY = exports.FILTER_KEY = 'signal.rule.rule_id';
/**
 * Filter button displayed next to the KQL bar at the top of the alert summary page.
 * For the AI for SOC effort, each integration has one rule associated with.
 * This means that deselecting an integration is equivalent to filtering out by the rule for that integration.
 * The EuiFilterButton works as follow:
 * - if an integration is selected, this means that no filters live in filterManager
 * - if an integration is deselected, this means that we have a negated filter for that rule in filterManager
 */
const IntegrationFilterButton = exports.IntegrationFilterButton = /*#__PURE__*/(0, _react.memo)(({
  integrations
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(value => !value), []);
  const {
    data: {
      query: {
        filterManager
      }
    }
  } = (0, _kibana.useKibana)().services;
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const [items, setItems] = (0, _react.useState)(integrations);
  const onChange = (0, _react.useCallback)((options, _, changedOption) => {
    setItems(options);
    const ruleId = changedOption.key;
    if (ruleId) {
      const existingFilters = filterManager.getFilters();
      const newFilters = (0, _filter.updateFiltersArray)(existingFilters, FILTER_KEY, ruleId, changedOption.checked === 'on');
      filterManager.setFilters(newFilters);
    }
  }, [filterManager]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    badgeColor: "accent",
    css: (0, _react2.css)`
        background-color: ${euiTheme.colors.backgroundBasePrimary};
      `,
    "data-test-subj": INTEGRATION_BUTTON_TEST_ID,
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    numActiveFilters: items.filter(item => item.checked === 'on').length,
    numFilters: items.filter(item => item.checked !== 'off').length,
    onClick: togglePopover
  }, INTEGRATIONS_BUTTON);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: togglePopover,
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    css: (0, _react2.css)`
            min-width: 200px;
          `,
    "data-test-subj": INTEGRATIONS_LIST_TEST_ID,
    options: items,
    onChange: onChange
  }, list => list)));
});
IntegrationFilterButton.displayName = 'IntegrationFilterButton';