"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertSummaryLensAttributes = exports.DEFAULT_PAGE_SIZE = void 0;
var _get_first_column_name = require("../../helpers/get_first_column_name");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LAYER_ID = '094d6c10-a28a-4780-8a0c-5789b73e4cef';
const DEFAULT_PAGE_SIZE = exports.DEFAULT_PAGE_SIZE = 5;
const getAlertSummaryLensAttributes = ({
  defaultPageSize = DEFAULT_PAGE_SIZE,
  esqlQuery,
  sorting,
  tableStackBy0
}) => ({
  references: [],
  state: {
    adHocDataViews: {},
    datasourceStates: {
      textBased: {
        layers: {
          [LAYER_ID]: {
            columns: [{
              columnId: 'tableStackBy0',
              fieldName: (0, _get_first_column_name.getFirstColumnName)(tableStackBy0)
            }, {
              columnId: 'count',
              fieldName: 'Count',
              inMetricDimension: true,
              meta: {
                type: 'number',
                esType: 'long'
              }
            }],
            index: 'F2772070-4F12-4603-A318-82F98BA69DAB',
            query: {
              esql: esqlQuery
            },
            timeField: '@timestamp'
          }
        }
      }
    },
    filters: [],
    // empty, because filters are applied directly to the lens.EmbeddableComponent
    query: {
      language: 'kuery',
      query: '' // empty, because the query from the query bar is applied directly to the lens.EmbeddableComponent
    },
    visualization: {
      columns: [{
        columnId: 'tableStackBy0',
        width: 300
      }, {
        columnId: 'count',
        summaryRow: 'sum'
      }],
      layerId: LAYER_ID,
      layerType: 'data',
      paging: {
        enabled: true,
        size: defaultPageSize
      },
      sorting: {
        ...sorting
      }
    }
  },
  title: i18n.ALERTS_SUMMARY,
  visualizationType: 'lnsDatatable'
});
exports.getAlertSummaryLensAttributes = getAlertSummaryLensAttributes;