"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityBaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_RULE_TYPES = [_constants.LEGACY_NOTIFICATIONS_ID, _securitysolutionRules.ESQL_RULE_TYPE_ID, _securitysolutionRules.EQL_RULE_TYPE_ID, _securitysolutionRules.INDICATOR_RULE_TYPE_ID, _securitysolutionRules.ML_RULE_TYPE_ID, _securitysolutionRules.QUERY_RULE_TYPE_ID, _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID, _securitysolutionRules.THRESHOLD_RULE_TYPE_ID, _securitysolutionRules.NEW_TERMS_RULE_TYPE_ID];
const alertingFeatures = SECURITY_RULE_TYPES.map(ruleTypeId => ({
  ruleTypeId,
  consumers: [_constants.SERVER_APP_ID]
}));
const getSecurityBaseKibanaFeature = ({
  savedObjects
}) => ({
  deprecated: {
    notice: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionSecurity.deprecationMessage', {
      defaultMessage: 'The {currentId} permissions are deprecated, please see {idV2}.',
      values: {
        currentId: _constants.SERVER_APP_ID,
        idV2: _constants.SECURITY_FEATURE_ID_V2
      }
    })
  },
  id: _constants.SERVER_APP_ID,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionTitleDeprecated', {
    defaultMessage: 'Security (Deprecated)'
  }),
  order: 1100,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: alertingFeatures,
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.securityGroupDescription', {
    defaultMessage: "Each sub-feature privilege in this group must be assigned individually. Global assignment is only supported if your pricing plan doesn't allow individual feature privileges."
  }),
  privileges: {
    all: {
      replacedBy: {
        default: [{
          feature: _constants.TIMELINE_FEATURE_ID,
          privileges: ['all']
        }, {
          feature: _constants.NOTES_FEATURE_ID,
          privileges: ['all']
        }, {
          feature: _constants.SECURITY_FEATURE_ID_V2,
          privileges: ['all']
        }],
        minimal: [{
          feature: _constants.TIMELINE_FEATURE_ID,
          privileges: ['all']
        }, {
          feature: _constants.NOTES_FEATURE_ID,
          privileges: ['all']
        }, {
          feature: _constants.SECURITY_FEATURE_ID_V2,
          privileges: ['minimal_all']
        }]
      },
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-all', 'lists-read', 'lists-summary', 'rac', 'cloud-security-posture-all', 'cloud-security-posture-read', 'cloud-defend-all', 'cloud-defend-read', 'timeline_write', 'timeline_read', 'notes_write', 'notes_read', 'bulkGetUserProfiles'],
      savedObject: {
        all: ['alert', ...savedObjects],
        read: []
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'crud']
    },
    read: {
      replacedBy: {
        default: [{
          feature: _constants.TIMELINE_FEATURE_ID,
          privileges: ['read']
        }, {
          feature: _constants.NOTES_FEATURE_ID,
          privileges: ['read']
        }, {
          feature: _constants.SECURITY_FEATURE_ID_V2,
          privileges: ['read']
        }],
        minimal: [{
          feature: _constants.TIMELINE_FEATURE_ID,
          privileges: ['read']
        }, {
          feature: _constants.NOTES_FEATURE_ID,
          privileges: ['read']
        }, {
          feature: _constants.SECURITY_FEATURE_ID_V2,
          privileges: ['minimal_read']
        }]
      },
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-read', 'rac', 'cloud-security-posture-read', 'cloud-defend-read', 'timeline_read', 'notes_read', 'bulkGetUserProfiles'],
      savedObject: {
        all: [],
        read: [...savedObjects]
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show']
    }
  }
});
exports.getSecurityBaseKibanaFeature = getSecurityBaseKibanaFeature;