"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProductProductFeaturesConfigurator = void 0;
var _cases_product_features_config = require("./cases_product_features_config");
var _security_product_features_config = require("./security_product_features_config");
var _assistant_product_features_config = require("./assistant_product_features_config");
var _attack_discovery_product_features_config = require("./attack_discovery_product_features_config");
var _timeline_product_features_config = require("./timeline_product_features_config");
var _notes_product_features_config = require("./notes_product_features_config");
var _siem_migrations_product_features_config = require("./siem_migrations_product_features_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getProductProductFeaturesConfigurator = enabledProductFeatureKeys => {
  return {
    security: (0, _security_product_features_config.getSecurityProductFeaturesConfigurator)(enabledProductFeatureKeys),
    cases: (0, _cases_product_features_config.getCasesProductFeaturesConfigurator)(enabledProductFeatureKeys),
    securityAssistant: (0, _assistant_product_features_config.getSecurityAssistantProductFeaturesConfigurator)(enabledProductFeatureKeys),
    attackDiscovery: (0, _attack_discovery_product_features_config.getAttackDiscoveryProductFeaturesConfigurator)(enabledProductFeatureKeys),
    timeline: (0, _timeline_product_features_config.getTimelineProductFeaturesConfigurator)(enabledProductFeatureKeys),
    notes: (0, _notes_product_features_config.getNotesProductFeaturesConfigurator)(enabledProductFeatureKeys),
    siemMigrations: (0, _siem_migrations_product_features_config.getSiemMigrationsProductFeaturesConfigurator)(enabledProductFeatureKeys)
  };
};
exports.getProductProductFeaturesConfigurator = getProductProductFeaturesConfigurator;