"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScheduledReportFormSchema = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _recurring_schedule_form_schema = require("@kbn/response-ops-recurring-schedule-form/schemas/recurring_schedule_form_schema");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _emails_validator = require("../validators/emails_validator");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const getScheduledReportFormSchema = (validateEmailAddresses, availableReportTypes) => {
  var _ref, _availableReportTypes;
  return {
    title: {
      type: _hook_form_lib.FIELD_TYPES.TEXT,
      label: i18n.SCHEDULED_REPORT_FORM_FILE_NAME_LABEL,
      validations: [{
        validator: emptyField(i18n.SCHEDULED_REPORT_FORM_FILE_NAME_REQUIRED_MESSAGE)
      }]
    },
    reportTypeId: {
      type: _hook_form_lib.FIELD_TYPES.SUPER_SELECT,
      label: i18n.SCHEDULED_REPORT_FORM_FILE_TYPE_LABEL,
      defaultValue: (_ref = availableReportTypes === null || availableReportTypes === void 0 ? void 0 : (_availableReportTypes = availableReportTypes[0]) === null || _availableReportTypes === void 0 ? void 0 : _availableReportTypes.id) !== null && _ref !== void 0 ? _ref : '',
      validations: [{
        validator: emptyField(i18n.SCHEDULED_REPORT_FORM_FILE_TYPE_REQUIRED_MESSAGE)
      }]
    },
    startDate: {},
    timezone: {},
    recurringSchedule: (0, _recurring_schedule_form_schema.getRecurringScheduleFormSchema)({
      allowInfiniteRecurrence: false
    }),
    sendByEmail: {
      type: _hook_form_lib.FIELD_TYPES.TOGGLE,
      label: i18n.SCHEDULED_REPORT_FORM_SEND_BY_EMAIL_LABEL,
      defaultValue: false
    },
    emailRecipients: {
      type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
      label: i18n.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_LABEL,
      defaultValue: [],
      validations: [{
        validator: emptyField(i18n.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_REQUIRED_MESSAGE)
      }, {
        isBlocking: false,
        validator: (0, _emails_validator.getEmailsValidator)(validateEmailAddresses)
      }]
    }
  };
};
exports.getScheduledReportFormSchema = getScheduledReportFormSchema;