"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewResultsInLensAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("@kbn/lens-plugin/common/constants");
var _esQuery = require("@kbn/es-query");
var _pack_queries_status_table = require("../live_queries/form/pack_queries_status_table");
var _kibana = require("../common/lib/kibana");
var _use_logs_data_view = require("../common/hooks/use_logs_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewResultsInLensActionComponent = ({
  actionId,
  buttonType,
  endDate,
  startDate,
  mode
}) => {
  const lensService = (0, _kibana.useKibana)().services.lens;
  const isLensAvailable = lensService === null || lensService === void 0 ? void 0 : lensService.canUseEditor();
  const {
    data: logsDataView
  } = (0, _use_logs_data_view.useLogsDataView)({
    skip: !actionId,
    checkOnly: true
  });
  const handleClick = (0, _react.useCallback)(event => {
    event.preventDefault();
    if (logsDataView) {
      lensService === null || lensService === void 0 ? void 0 : lensService.navigateToPrefilledEditor({
        id: '',
        timeRange: {
          from: startDate !== null && startDate !== void 0 ? startDate : 'now-1d',
          to: endDate !== null && endDate !== void 0 ? endDate : 'now',
          mode: (mode !== null && mode !== void 0 ? mode : startDate || endDate) ? 'absolute' : 'relative'
        },
        attributes: getLensAttributes(logsDataView, actionId)
      }, {
        openInNewTab: true,
        skipAppLeave: true
      });
    }
  }, [actionId, endDate, lensService, logsDataView, mode, startDate]);
  const isDisabled = (0, _react.useMemo)(() => !actionId || !logsDataView, [actionId, logsDataView]);
  if (!isLensAvailable) {
    return null;
  }
  if (buttonType === _pack_queries_status_table.ViewResultsActionButtonType.button) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "lensApp",
      onClick: handleClick,
      isDisabled: isDisabled
    }, VIEW_IN_LENS);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_IN_LENS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "lensApp",
    disabled: false,
    onClick: handleClick,
    "aria-label": VIEW_IN_LENS,
    isDisabled: isDisabled
  }));
};
function getLensAttributes(logsDataView, actionId, agentIds) {
  const dataLayer = {
    columnOrder: ['8690befd-fd69-4246-af4a-dd485d2a3b38', 'ed999e9d-204c-465b-897f-fe1a125b39ed'],
    columns: {
      '8690befd-fd69-4246-af4a-dd485d2a3b38': {
        sourceField: 'type',
        isBucketed: true,
        dataType: 'string',
        scale: 'ordinal',
        operationType: 'terms',
        label: 'Top values of type',
        params: {
          otherBucket: true,
          size: 5,
          missingBucket: false,
          orderBy: {
            columnId: 'ed999e9d-204c-465b-897f-fe1a125b39ed',
            type: 'column'
          },
          orderDirection: 'desc'
        }
      },
      'ed999e9d-204c-465b-897f-fe1a125b39ed': {
        sourceField: _constants.DOCUMENT_FIELD_NAME,
        isBucketed: false,
        dataType: 'number',
        scale: 'ratio',
        operationType: 'count',
        label: 'Count of records'
      }
    },
    incompleteColumns: {}
  };
  const xyConfig = {
    shape: 'pie',
    layers: [{
      layerType: 'data',
      legendDisplay: 'default',
      nestedLegend: false,
      layerId: 'layer1',
      metrics: ['ed999e9d-204c-465b-897f-fe1a125b39ed'],
      numberDisplay: 'percent',
      primaryGroups: ['8690befd-fd69-4246-af4a-dd485d2a3b38'],
      categoryDisplay: 'default'
    }]
  };
  const agentIdsQuery = agentIds !== null && agentIds !== void 0 && agentIds.length ? {
    bool: {
      minimum_should_match: 1,
      should: agentIds === null || agentIds === void 0 ? void 0 : agentIds.map(agentId => ({
        match_phrase: {
          'agent.id': agentId
        }
      }))
    }
  } : undefined;
  return {
    visualizationType: 'lnsPie',
    title: `Action ${actionId} results`,
    references: [{
      id: logsDataView.id,
      name: 'indexpattern-datasource-current-indexpattern',
      type: 'index-pattern'
    }, {
      id: logsDataView.id,
      name: 'indexpattern-datasource-layer-layer1',
      type: 'index-pattern'
    }, {
      name: 'filter-index-pattern-0',
      id: logsDataView.id,
      type: 'index-pattern'
    }],
    state: {
      datasourceStates: {
        formBased: {
          layers: {
            layer1: dataLayer
          }
        }
      },
      filters: [{
        $state: {
          store: _esQuery.FilterStateStore.APP_STATE
        },
        meta: {
          index: 'filter-index-pattern-0',
          negate: false,
          alias: null,
          disabled: false,
          params: {
            query: actionId
          },
          type: 'phrase',
          key: 'action_id'
        },
        query: {
          match_phrase: {
            action_id: actionId
          }
        }
      }, ...(agentIdsQuery ? [{
        $state: {
          store: _esQuery.FilterStateStore.APP_STATE
        },
        meta: {
          alias: 'agent IDs',
          disabled: false,
          index: 'filter-index-pattern-0',
          key: 'query',
          negate: false,
          type: 'custom',
          value: JSON.stringify(agentIdsQuery)
        },
        query: agentIdsQuery
      }] : [])],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: xyConfig
    }
  };
}
const VIEW_IN_LENS = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewLensResultsActionAriaLabel', {
  defaultMessage: 'View in Lens'
});
const ViewResultsInLensAction = exports.ViewResultsInLensAction = /*#__PURE__*/_react.default.memo(ViewResultsInLensActionComponent);