"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getData = void 0;
var _constants = require("../constants");
var _utils = require("../utils");
var _metric_query = require("./metric_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_DATA_RESPONSE = {
  [_constants.UNGROUPED_FACTORY_KEY]: {
    value: null,
    trigger: false,
    bucketKey: {
      groupBy0: _constants.UNGROUPED_FACTORY_KEY
    }
  }
};
const createContainerList = containerContext => {
  return containerContext.buckets.map(bucket => {
    var _bucket$container$hit, _containerHits$0$_sou;
    const containerHits = (_bucket$container$hit = bucket.container.hits) === null || _bucket$container$hit === void 0 ? void 0 : _bucket$container$hit.hits;
    return (containerHits === null || containerHits === void 0 ? void 0 : containerHits.length) > 0 ? (_containerHits$0$_sou = containerHits[0]._source) === null || _containerHits$0$_sou === void 0 ? void 0 : _containerHits$0$_sou.container : undefined;
  }).filter(container => container !== undefined);
};
const getData = async (esClient, params, index, timeFieldName, groupBy, searchConfiguration, esQueryConfig, compositeSize, alertOnGroupDisappear, timeframe, logger, runtimeMappings, lastPeriodEnd, previousResults = {}, afterKey) => {
  const handleResponse = (aggs, previous, successfulShards) => {
    var _aggs$all;
    // This is absolutely NO DATA
    if (successfulShards === 0) {
      return NO_DATA_RESPONSE;
    }
    if (aggs.groupings) {
      const {
        groupings
      } = aggs;
      const nextAfterKey = groupings.after_key;
      for (const bucket of groupings.buckets) {
        var _additionalContext$hi;
        const key = Object.values(bucket.key).join(',');
        const {
          shouldTrigger,
          missingGroup,
          currentPeriod,
          additionalContext,
          containerContext
        } = bucket;
        const {
          aggregatedValue
        } = currentPeriod.buckets.all;
        const containerList = containerContext ? createContainerList(containerContext) : undefined;
        const bucketHits = additionalContext === null || additionalContext === void 0 ? void 0 : (_additionalContext$hi = additionalContext.hits) === null || _additionalContext$hi === void 0 ? void 0 : _additionalContext$hi.hits;
        const additionalContextSource = bucketHits && bucketHits.length > 0 ? bucketHits[0]._source : null;
        const flattenGrouping = {};
        const groups = typeof groupBy === 'string' ? [groupBy] : groupBy !== null && groupBy !== void 0 ? groupBy : [];
        groups.map((group, groupIndex) => {
          flattenGrouping[group] = bucket.key[`groupBy${groupIndex}`];
        });
        if (missingGroup && missingGroup.value > 0) {
          previous[key] = {
            trigger: false,
            value: null,
            bucketKey: bucket.key,
            flattenGrouping
          };
        } else {
          const value = aggregatedValue ? aggregatedValue.value : null;
          previous[key] = {
            trigger: shouldTrigger && shouldTrigger.value > 0 || false,
            value,
            bucketKey: bucket.key,
            flattenGrouping,
            container: containerList,
            ...additionalContextSource
          };
        }
      }
      if (nextAfterKey) {
        return getData(esClient, params, index, timeFieldName, groupBy, searchConfiguration, esQueryConfig, compositeSize, alertOnGroupDisappear, timeframe, logger, runtimeMappings, lastPeriodEnd, previous, nextAfterKey);
      }
      return previous;
    }
    if ((_aggs$all = aggs.all) !== null && _aggs$all !== void 0 && _aggs$all.buckets.all) {
      const {
        currentPeriod,
        shouldTrigger
      } = aggs.all.buckets.all;
      const {
        aggregatedValue
      } = currentPeriod.buckets.all;
      const value = aggregatedValue ? aggregatedValue.value : null;
      return {
        [_constants.UNGROUPED_FACTORY_KEY]: {
          value,
          trigger: shouldTrigger && shouldTrigger.value > 0 || false,
          bucketKey: {
            groupBy0: _constants.UNGROUPED_FACTORY_KEY
          }
        }
      };
    } else {
      return NO_DATA_RESPONSE;
    }
  };
  const fieldsExisted = groupBy !== null && groupBy !== void 0 && groupBy.includes(_utils.KUBERNETES_POD_UID) ? await (0, _utils.doFieldsExist)(esClient, [_utils.CONTAINER_ID], index) : null;
  const request = {
    index,
    allow_no_indices: true,
    ignore_unavailable: true,
    body: (0, _metric_query.getElasticsearchMetricQuery)(params, timeframe, timeFieldName, compositeSize, alertOnGroupDisappear, searchConfiguration, esQueryConfig, runtimeMappings, lastPeriodEnd, groupBy, afterKey, fieldsExisted)
  };
  const body = await esClient.search(request);
  const {
    aggregations,
    _shards
  } = body;
  if (aggregations) {
    return handleResponse(aggregations, previousResults, _shards.successful);
  } else if (_shards.successful) {
    return previousResults;
  }
  return NO_DATA_RESPONSE;
};
exports.getData = getData;