"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGenAIConnectors = useGenAIConnectors;
exports.useGenAIConnectorsWithoutContext = useGenAIConnectorsWithoutContext;
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_observability_ai_assistant = require("./use_observability_ai_assistant");
var _use_kibana = require("./use_kibana");
var _inference_endpoint_exists = require("./inference_endpoint_exists");
var _get_elastic_managed_llm_connector = require("../utils/get_elastic_managed_llm_connector");
var _get_inference_connector = require("../../common/utils/get_inference_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Import from gen-ai-settings-plugin (package) once available
const NO_DEFAULT_CONNECTOR = 'NO_DEFAULT_CONNECTOR';
function useGenAIConnectors() {
  const assistant = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  return useGenAIConnectorsWithoutContext(assistant);
}
function useGenAIConnectorsWithoutContext(assistant) {
  var _connectors$;
  const [connectors, setConnectors] = (0, _react.useState)(undefined);
  const {
    services: {
      uiSettings,
      http
    }
  } = (0, _use_kibana.useKibana)();
  const defaultConnector = uiSettings.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR);
  const genAISettingsDefaultOnly = uiSettings.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY, false);
  const isConnectorSelectionRestricted = genAISettingsDefaultOnly && defaultConnector !== NO_DEFAULT_CONNECTOR;
  const [lastUsedConnector, setLastUsedConnector] = (0, _useLocalStorage.default)(`xpack.observabilityAiAssistant.lastUsedConnector`, '');
  const selectedConnector = (0, _react.useMemo)(() => {
    if (isConnectorSelectionRestricted) {
      return defaultConnector;
    }
    if (lastUsedConnector) {
      return lastUsedConnector;
    }
    if (defaultConnector !== NO_DEFAULT_CONNECTOR) {
      return defaultConnector;
    }
    return undefined;
  }, [isConnectorSelectionRestricted, defaultConnector, lastUsedConnector]);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  const controller = (0, _react.useMemo)(() => new AbortController(), []);
  const fetchConnectors = (0, _react.useCallback)(async () => {
    setLoading(true);
    assistant.callApi('GET /internal/observability_ai_assistant/connectors', {
      signal: controller.signal
    }).then(results => {
      return results.reduce(async (result, connector) => {
        var _config;
        if (connector.actionTypeId !== _get_elastic_managed_llm_connector.INFERENCE_CONNECTOR_ACTION_TYPE_ID || connector.actionTypeId === _get_elastic_managed_llm_connector.INFERENCE_CONNECTOR_ACTION_TYPE_ID && (await (0, _inference_endpoint_exists.isInferenceEndpointExists)(http, connector === null || connector === void 0 ? void 0 : (_config = connector.config) === null || _config === void 0 ? void 0 : _config.inferenceId))) {
          return [...(await result), connector];
        }
        return result;
      }, Promise.resolve([])).then(c => {
        if (isConnectorSelectionRestricted) {
          const defaultC = c.find(con => con.id === defaultConnector);
          c = defaultC ? [defaultC] : [];
        }
        setConnectors(c);
        setLastUsedConnector(connectorId => {
          if (connectorId && c.findIndex(result => result.id === connectorId) === -1) {
            return '';
          }
          return connectorId;
        });
        setError(undefined);
      });
    }).catch(err => {
      setError(err);
      setConnectors(undefined);
    }).finally(() => {
      setLoading(false);
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [assistant, controller.signal, defaultConnector, isConnectorSelectionRestricted]);
  (0, _react.useEffect)(() => {
    fetchConnectors();
    return () => {
      controller.abort();
    };
  }, [controller, fetchConnectors]);
  const getConnector = id => {
    const connector = connectors === null || connectors === void 0 ? void 0 : connectors.find(_connector => _connector.id === id);
    return (0, _get_inference_connector.getInferenceConnectorInfo)(connector);
  };
  return {
    connectors,
    loading,
    error,
    selectedConnector: selectedConnector || (connectors === null || connectors === void 0 ? void 0 : (_connectors$ = connectors[0]) === null || _connectors$ === void 0 ? void 0 : _connectors$.id),
    selectConnector: id => {
      setLastUsedConnector(id);
    },
    reloadConnectors: () => {
      fetchConnectors();
    },
    getConnector,
    isConnectorSelectionRestricted,
    defaultConnector: defaultConnector === NO_DEFAULT_CONNECTOR ? undefined : defaultConnector
  };
}