"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddModelFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _check_capabilities = require("../capabilities/check_capabilities");
var _kibana = require("../contexts/kibana");
var _eland_python_client = require("./eland_python_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Flyout for downloading elastic curated models and showing instructions for importing third-party models.
 */
const AddModelFlyout = ({
  onClose,
  onSubmit,
  modelDownloads
}) => {
  const canCreateTrainedModels = (0, _check_capabilities.usePermissionCheck)('canCreateTrainedModels');
  const isClickToDownloadTabVisible = canCreateTrainedModels && modelDownloads.length > 0;
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(isClickToDownloadTabVisible ? 'clickToDownload' : 'manualDownload');
  const tabs = (0, _react.useMemo)(() => {
    return [...(isClickToDownloadTabVisible ? [{
      id: 'clickToDownload',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.clickToDownloadTabLabel",
        defaultMessage: "Click to Download"
      }),
      content: /*#__PURE__*/_react.default.createElement(ClickToDownloadTabContent, {
        modelDownloads: modelDownloads,
        onModelDownload: onSubmit
      })
    }] : []), {
      id: 'manualDownload',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.thirdPartyLabel",
        defaultMessage: "Manual Download"
      }),
      content: /*#__PURE__*/_react.default.createElement(ManualDownloadTabContent, null)
    }];
  }, [isClickToDownloadTabVisible, modelDownloads, onSubmit]);
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": 'addTrainedModelFlyout',
    "data-test-subj": 'mlAddTrainedModelFlyout'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: 'addTrainedModelFlyout'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.addModelFlyout.title",
    defaultMessage: "Add a trained model"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    isSelected: selectedTabId === tab.id,
    onClick: setSelectedTabId.bind(null, tab.id),
    "data-test-subj": `mlAddTrainedModelFlyoutTab ${tab.id}`
  }, tab.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, selectedTabContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.addModelFlyout.closeButtonLabel",
    defaultMessage: "Close"
  }))))));
};
exports.AddModelFlyout = AddModelFlyout;
/**
 * Tab content for selecting a model to download.
 */
const ClickToDownloadTabContent = ({
  modelDownloads,
  onModelDownload
}) => {
  var _modelDownloads$find;
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const [selectedModelId, setSelectedModelId] = (0, _react.useState)((_modelDownloads$find = modelDownloads.find(m => m.recommended)) === null || _modelDownloads$find === void 0 ? void 0 : _modelDownloads$find.model_id);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.entries((0, _lodash.groupBy)(modelDownloads, 'modelName')).map(([modelName, models]) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: modelName
    }, modelName === 'elser' ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's',
      alignItems: 'center'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElastic",
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 's'
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.elserTitle",
      defaultMessage: "ELSER (Elastic Learned Sparse EncodeR)"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 's',
      "data-test-subj": "mlAddTrainedModelFlyoutElserModelHeaderCopy"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.addModelFlyout.elserDescription",
      defaultMessage: "ELSER is Elastic's NLP model for English semantic search, utilizing sparse vectors. It prioritizes intent and contextual meaning over literal term matching, optimized specifically for English documents and queries on the Elastic platform."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.ml.nlpElser,
      external: true,
      target: '_blank'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",
      defaultMessage: "View documentation"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm'
    })) : null, modelName === 'e5' ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 's'
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.e5Title",
      defaultMessage: "E5 (EmbEddings from bidirEctional Encoder rEpresentations)"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 's'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.addModelFlyout.e5Description",
      defaultMessage: "E5 is a third party NLP model that enables you to perform multi-lingual semantic search by using dense vector representations. This model performs best for non-English language documents and queries."
    }), "\xA0", models[0].disclaimer)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'spaceBetween',
      gutterSize: 'none'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.ml.nlpE5,
      external: true,
      target: '_blank'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",
      defaultMessage: "View documentation"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'l'
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
      legend: {
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.chooseModelLabel",
          defaultMessage: "Choose a model"
        })
      }
    }, models.map((model, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: model.model_id
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
        id: model.model_id,
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: 's',
          alignItems: 'center',
          justifyContent: 'spaceBetween',
          "data-test-subj": "mlAddTrainedModelFlyoutChooseModelPanels"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement("header", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: 's'
        }, /*#__PURE__*/_react.default.createElement("b", null, model.os === 'Linux' && model.arch === 'amd64' ? /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": `mlAddTrainedModelFlyoutModelPanel-${modelName}-${model.model_id}`
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.intelLinuxLabel",
          defaultMessage: "Intel and Linux optimized"
        })) : /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": `mlAddTrainedModelFlyoutModelPanel-${modelName}-${model.model_id}`
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.crossPlatformLabel",
          defaultMessage: "Cross platform"
        }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: 's',
          color: 'subdued'
        }, model.model_id)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: 's',
          alignItems: 'center'
        }, model.recommended ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.trainedModels.modelsList.recommendedDownloadContent",
            defaultMessage: "Recommended model version for your cluster's hardware configuration"
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.recommendedDownloadLabel",
          defaultMessage: "Recommended"
        })))) : null, model.licenseUrl && model.softwareLicense ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          target: '_blank',
          href: model.licenseUrl
        }, model.softwareLicense === 'MIT' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.modelsList.mitLicenseLabel",
          defaultMessage: "License: MIT"
        }) : null)) : null))),
        name: model.model_id,
        value: model.model_id,
        checked: model.model_id === selectedModelId,
        onChange: setSelectedModelId.bind(null, model.model_id)
      }), index < models.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }) : null);
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onModelDownload.bind(null, selectedModelId),
    fill: true,
    disabled: !selectedModelId,
    "data-test-subj": "mlAddTrainedModelFlyoutDownloadButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.addModelFlyout.downloadButtonLabel",
    defaultMessage: "Download"
  })));
};

/**
 * Manual download tab content for showing instructions for importing third-party models.
 */
const ManualDownloadTabContent = () => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  return /*#__PURE__*/_react.default.createElement(_eland_python_client.ElandPythonClient, {
    supportedNlpModels: docLinks.links.enterpriseSearch.supportedNlpModels,
    nlpImportModel: docLinks.links.ml.nlpImportModel
  });
};